/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.cluster;

import appeng.api.config.CpuSelectionMode;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.CraftingJobStatus;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.GenericStack;
import appeng.crafting.inv.ListCraftingInventory;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.pedroksl.advanced_ae.common.cluster.AdvCraftingCPUCluster;
import net.pedroksl.advanced_ae.common.logic.AdvCraftingCPULogic;
import net.pedroksl.advanced_ae.common.logic.ElapsedTimeTracker;
import org.jetbrains.annotations.Nullable;

public class AdvCraftingCPU
implements ICraftingCPU {
    final UUID uniqueId;
    final long bytes;
    private final AdvCraftingCPUCluster cluster;
    public final AdvCraftingCPULogic craftingLogic = new AdvCraftingCPULogic(this);
    public GenericStack finalOutput;

    public AdvCraftingCPU(AdvCraftingCPUCluster cluster, UUID uniqueId, long bytes) {
        this.uniqueId = uniqueId;
        this.cluster = cluster;
        this.bytes = bytes;
    }

    protected AdvCraftingCPU(AdvCraftingCPUCluster cluster, long storage) {
        this.uniqueId = null;
        this.cluster = cluster;
        this.bytes = storage;
    }

    public boolean isBusy() {
        return this.craftingLogic.hasJob();
    }

    @Nullable
    public CraftingJobStatus getJobStatus() {
        GenericStack finalOutput = this.craftingLogic.getFinalJobOutput();
        if (finalOutput != null) {
            ElapsedTimeTracker elapsedTimeTracker = this.craftingLogic.getElapsedTimeTracker();
            long progress = Math.max(0L, elapsedTimeTracker.getStartItemCount() - elapsedTimeTracker.getRemainingItemCount());
            return new CraftingJobStatus(finalOutput, elapsedTimeTracker.getStartItemCount(), progress, elapsedTimeTracker.getElapsedTime());
        }
        return null;
    }

    public void cancelJob() {
        if (this.uniqueId == null) {
            return;
        }
        this.craftingLogic.cancel();
        this.cluster.cancelJob(this.uniqueId);
    }

    public long getAvailableStorage() {
        return this.bytes;
    }

    public int getCoProcessors() {
        return this.cluster.getCoProcessors();
    }

    @Nullable
    public Component getName() {
        return this.cluster.getName();
    }

    public CpuSelectionMode getSelectionMode() {
        return this.cluster.getSelectionMode();
    }

    public void markDirty() {
        this.cluster.markDirty();
    }

    public boolean isActive() {
        return this.cluster.isActive();
    }

    public Level getLevel() {
        return this.cluster.getLevel();
    }

    public IGrid getGrid() {
        return this.cluster.getGrid();
    }

    public void updateOutput(GenericStack stack) {
        this.finalOutput = stack;
    }

    public ListCraftingInventory getInventory() {
        return this.craftingLogic.getInventory();
    }

    public void deactivate() {
        this.cluster.deactivate(this.uniqueId);
    }

    public IActionSource getSrc() {
        return this.cluster.getSrc();
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        this.craftingLogic.writeToNBT(data, registries);
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        this.craftingLogic.readFromNBT(data, registries);
    }
}

