/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.helpers;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MagnetHelpers {
    public static AABB getBoundingBox(Vec3 pos, int range) {
        return new AABB(pos.x - (double)range, pos.y - (double)range, pos.z - (double)range, pos.x + (double)range, pos.y + (double)range, pos.z + (double)range);
    }

    public static boolean validEntities(ItemEntity item, Player player, List<GenericStack> filter, boolean blacklist) {
        if (item.isAlive() && (player instanceof ServerPlayer || item.tickCount > 1) && !item.getItem().isEmpty()) {
            if (item.hasPickUpDelay() && (item.thrower == null || item.thrower.equals(player.getUUID()))) {
                return false;
            }
            if (item.getPersistentData().contains("PreventRemoteMovement")) {
                return false;
            }
            if (filter.isEmpty()) {
                return true;
            }
            boolean containedInFilter = !filter.stream().filter(gen -> AEItemKey.of((ItemStack)item.getItem()).matches(gen)).toList().isEmpty();
            return containedInFilter && !blacklist || !containedInFilter && blacklist;
        }
        return false;
    }
}

