/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.guisync.GuiSync;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.slot.DisabledSlot;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.definitions.AAESlotSemantics;
import net.pedroksl.advanced_ae.common.inventory.QuantumArmorMenuHost;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;

public class QuantumArmorStyleConfigMenu
extends AEBaseMenu
implements ISubMenu {
    private final QuantumArmorMenuHost<?> host;
    @GuiSync(value=13)
    public int slotIndex;
    private static final String SELECT_SLOT = "select_slot";
    public static final String LAST_SLOT_INDEX = "aae$lastSlotIndex";

    public QuantumArmorStyleConfigMenu(int id, Inventory playerInventory, QuantumArmorMenuHost<?> host) {
        super(AAEMenus.QUANTUM_ARMOR_STYLE_CONFIG.get(), id, playerInventory, host);
        this.host = host;
        int indexOfFirstQuantum = -1;
        for (int i = 3; i >= 0; --i) {
            int index = 36 + i;
            DisabledSlot slot = new DisabledSlot((Container)playerInventory, index);
            if (slot.getItem().getItem() instanceof QuantumArmorBase && indexOfFirstQuantum == -1) {
                indexOfFirstQuantum = index;
            }
            this.addSlot((Slot)slot, AAESlotSemantics.ARMOR);
        }
        this.registerClientAction(SELECT_SLOT, Integer.class, this::setSelectedItemSlot);
        if (this.getPlayer().getPersistentData().contains(LAST_SLOT_INDEX)) {
            this.setSelectedItemSlot(this.getPlayer().getPersistentData().getInt(LAST_SLOT_INDEX));
        } else {
            this.setSelectedItemSlot(indexOfFirstQuantum);
        }
    }

    public QuantumArmorMenuHost<?> getHost() {
        return this.host;
    }

    public static void open(ServerPlayer player, MenuHostLocator locator, int slotIndex) {
        MenuOpener.open(AAEMenus.QUANTUM_ARMOR_STYLE_CONFIG.get(), (Player)player, (MenuHostLocator)locator);
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof QuantumArmorStyleConfigMenu) {
            QuantumArmorStyleConfigMenu cca = (QuantumArmorStyleConfigMenu)abstractContainerMenu;
            cca.setSlotIndex(slotIndex);
            cca.broadcastChanges();
        }
    }

    public void setSlotIndex(int index) {
        this.slotIndex = index;
    }

    public void setSelectedItemSlot(int index) {
        if (this.isClientSide()) {
            this.sendClientAction(SELECT_SLOT, index);
            this.getPlayer().getPersistentData().putInt(LAST_SLOT_INDEX, index);
            return;
        }
        this.host.setSelectedItemSlot(index);
    }

    public void updateItemColors(List<Integer> slots, int color) {
        for (Integer slotIndex : slots) {
            Item item;
            Slot slot = this.getSlot(slotIndex);
            if (slot == null || !slot.hasItem() || !((item = slot.getItem().getItem()) instanceof QuantumArmorBase)) continue;
            QuantumArmorBase armor = (QuantumArmorBase)item;
            armor.setTintColor(this.getPlayerInventory().player, slot.getItem(), color);
        }
    }
}

