/*
 * Decompiled with CFR 0.152.
 */
package tamaized.ae2jeiintegration.integration.modules.jei.categories;

import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.localization.ItemModText;
import appeng.items.tools.powered.EntropyManipulatorItem;
import appeng.recipes.AERecipeTypes;
import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import tamaized.ae2jeiintegration.integration.modules.jei.JEIPlugin;
import tamaized.ae2jeiintegration.integration.modules.jei.categories.AbstractCategory;
import tamaized.ae2jeiintegration.integration.modules.jei.drawables.DrawableHelper;
import tamaized.ae2jeiintegration.integration.modules.jei.drawables.LabelDrawable;

public class EntropyManipulatorCategory
extends AbstractCategory<RecipeHolder<EntropyRecipe>> {
    public static final RecipeType<RecipeHolder<EntropyRecipe>> RECIPE_TYPE = RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)AERecipeTypes.ENTROPY);
    private final IDrawable blockDestroyOverlay;
    private final int centerX;
    private final IRecipeWidget heatWidget;
    private final IRecipeWidget coolWidget;

    public EntropyManipulatorCategory(IGuiHelper guiHelper) {
        super(guiHelper, (IDrawable)guiHelper.drawableBuilder(AppEng.makeId((String)"textures/item/entropy_manipulator.png"), 0, 0, 16, 16).setTextureSize(16, 16).build(), ((EntropyManipulatorItem)AEItems.ENTROPY_MANIPULATOR.asItem()).getDescription(), (IDrawable)guiHelper.createBlankDrawable(130, 50));
        this.blockDestroyOverlay = guiHelper.createDrawable(JEIPlugin.TEXTURE, 0, 52, 16, 16);
        IDrawableStatic iconHeat = guiHelper.createDrawable(JEIPlugin.TEXTURE, 0, 68, 6, 6);
        IDrawableStatic iconCool = guiHelper.createDrawable(JEIPlugin.TEXTURE, 6, 68, 6, 6);
        this.centerX = this.background.getWidth() / 2;
        this.heatWidget = new ModeWidget(guiHelper, iconHeat, (Component)ItemModText.ENTROPY_MANIPULATOR_HEAT.text(new Object[]{1600}), ItemModText.RIGHT_CLICK, this.centerX);
        this.coolWidget = new ModeWidget(guiHelper, iconCool, (Component)ItemModText.ENTROPY_MANIPULATOR_COOL.text(new Object[]{1600}), ItemModText.SHIFT_RIGHT_CLICK, this.centerX);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<EntropyRecipe> holder, IFocusGroup focuses) {
        EntropyRecipe recipe = (EntropyRecipe)holder.value();
        IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, this.centerX - 36, 15).setStandardSlotBackground();
        Block inputBlock = recipe.getInput().block().map(EntropyRecipe.BlockInput::block).orElse(null);
        Fluid inputFluid = recipe.getInput().fluid().map(EntropyRecipe.FluidInput::fluid).orElse(null);
        this.setFluidOrBlockSlot(input, inputBlock, inputFluid);
        int x = this.centerX + 20;
        Block outputBlock = recipe.getOutput().block().map(EntropyRecipe.BlockOutput::block).orElse(null);
        Fluid outputFluid = recipe.getOutput().fluid().map(EntropyRecipe.FluidOutput::fluid).orElse(null);
        if (outputBlock == Blocks.AIR && (outputFluid == null || outputFluid == Fluids.EMPTY)) {
            IRecipeSlotBuilder destroyed = builder.addSlot(RecipeIngredientRole.RENDER_ONLY, x, 15).setStandardSlotBackground();
            this.setFluidOrBlockSlot(destroyed, inputBlock, inputFluid);
            destroyed.setOverlay(this.blockDestroyOverlay, 0, 0);
            destroyed.addRichTooltipCallback((recipeSlotView, tooltip) -> tooltip.add((FormattedText)ItemModText.CONSUMED.text().withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})));
            x += 18;
        } else if (outputBlock != null || outputFluid != null) {
            IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, x, 15).setStandardSlotBackground();
            this.setFluidOrBlockSlot(output, outputBlock, outputFluid);
            x += 18;
        }
        for (ItemStack drop : recipe.getDrops()) {
            IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, x, 15).setStandardSlotBackground();
            output.addItemStack(drop);
            x += 18;
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<EntropyRecipe> holder, IFocusGroup focuses) {
        EntropyRecipe recipe = (EntropyRecipe)holder.value();
        IRecipeWidget widget = switch (recipe.getMode()) {
            default -> throw new MatchException(null, null);
            case EntropyMode.HEAT -> this.heatWidget;
            case EntropyMode.COOL -> this.coolWidget;
        };
        builder.addWidget(widget);
    }

    private void setFluidOrBlockSlot(IRecipeSlotBuilder slot, @Nullable Block block, @Nullable Fluid fluid) {
        if (fluid != null) {
            if (!fluid.isSource(fluid.defaultFluidState())) {
                if (fluid instanceof FlowingFluid) {
                    FlowingFluid flowingFluid = (FlowingFluid)fluid;
                    slot.addFluidStack(flowingFluid.getSource());
                } else {
                    slot.addFluidStack(fluid);
                    AELog.warn((String)"Don't know how to get the source fluid for %s", (Object[])new Object[]{fluid});
                }
            } else {
                slot.addFluidStack(fluid);
            }
        } else if (block != null) {
            slot.addItemStack(block.asItem().getDefaultInstance());
        }
    }

    public RecipeType<RecipeHolder<EntropyRecipe>> getRecipeType() {
        return RECIPE_TYPE;
    }

    public ResourceLocation getRegistryName(RecipeHolder<EntropyRecipe> holder) {
        return holder.id();
    }

    private static class ModeWidget
    implements IRecipeWidget {
        private final ScreenPosition position;
        private final IDrawableStatic icon;
        private final LabelDrawable modeLabel;
        private final IDrawable interactionText;
        private final IDrawableStatic unfilledArrow;
        private final int centerX;

        public ModeWidget(IGuiHelper guiHelper, IDrawableStatic icon, Component modeText, ItemModText interaction, int centerX) {
            this.centerX = centerX;
            this.position = new ScreenPosition(0, 0);
            this.icon = icon;
            this.modeLabel = new LabelDrawable(modeText).bodyText();
            this.interactionText = new LabelDrawable((Component)interaction.text()).bodyText();
            this.unfilledArrow = DrawableHelper.getUnfilledArrow(guiHelper);
        }

        public ScreenPosition getPosition() {
            return this.position;
        }

        public void draw(GuiGraphics guiGraphics, double mouseX, double mouseY) {
            int modeLabelCenterX = this.centerX + 4;
            this.modeLabel.draw(guiGraphics, modeLabelCenterX, 2);
            int iconX = modeLabelCenterX + this.modeLabel.getX() - 9;
            this.icon.draw(guiGraphics, iconX, 3);
            this.unfilledArrow.draw(guiGraphics, this.centerX - this.unfilledArrow.getWidth() / 2, 14);
            this.interactionText.draw(guiGraphics, this.centerX, 38);
        }
    }
}

