/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.api.recipes.outputs;

import java.util.Objects;
import java.util.function.IntSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class ExtraOutputHelper {
    private ExtraOutputHelper() {
    }

    public static IOutputHandler<@NotNull ItemStack> getOutputHandler(final IInventorySlot slot, final CachedRecipe.OperationTracker.RecipeError notEnoughSpaceError, final IntSupplier baselineMaxOperations) {
        Objects.requireNonNull(slot, "Slot cannot be null.");
        Objects.requireNonNull(notEnoughSpaceError, "Not enough space error cannot be null.");
        return new IOutputHandler<ItemStack>(){

            public void handleOutput(ItemStack toOutput, int operations) {
                ExtraOutputHelper.handleOutput(slot, toOutput, operations);
            }

            public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, ItemStack toOutput) {
                ExtraOutputHelper.calculateOperationsCanSupport(tracker, notEnoughSpaceError, slot, toOutput, baselineMaxOperations);
            }
        };
    }

    public static IOutputHandler<// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SawmillRecipe.ChanceOutput> getOutputHandler(final IInventorySlot mainSlot, final CachedRecipe.OperationTracker.RecipeError mainSlotNotEnoughSpaceError, final IInventorySlot secondarySlot, final CachedRecipe.OperationTracker.RecipeError secondarySlotNotEnoughSpaceError, final IntSupplier baselineMaxOperations) {
        Objects.requireNonNull(mainSlot, "Main slot cannot be null.");
        Objects.requireNonNull(secondarySlot, "Secondary/Extra slot cannot be null.");
        Objects.requireNonNull(mainSlotNotEnoughSpaceError, "Main slot not enough space error cannot be null.");
        Objects.requireNonNull(secondarySlotNotEnoughSpaceError, "Secondary/Extra slot not enough space error cannot be null.");
        return new IOutputHandler<SawmillRecipe.ChanceOutput>(){

            public void handleOutput(SawmillRecipe.ChanceOutput toOutput, int operations) {
                ExtraOutputHelper.handleOutput(mainSlot, toOutput.getMainOutput(), operations);
                ItemStack secondaryOutput = toOutput.getSecondaryOutput();
                for (int i = 0; i < operations; ++i) {
                    ExtraOutputHelper.handleOutput(secondarySlot, secondaryOutput, operations);
                    if (i >= operations - 1) continue;
                    secondaryOutput = toOutput.nextSecondaryOutput();
                }
            }

            public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, SawmillRecipe.ChanceOutput toOutput) {
                ExtraOutputHelper.calculateOperationsCanSupport(tracker, mainSlotNotEnoughSpaceError, mainSlot, toOutput.getMainOutput(), baselineMaxOperations);
                if (tracker.shouldContinueChecking()) {
                    ExtraOutputHelper.calculateOperationsCanSupport(tracker, secondarySlotNotEnoughSpaceError, secondarySlot, toOutput.getMaxSecondaryOutput(), baselineMaxOperations);
                }
            }
        };
    }

    private static void handleOutput(IInventorySlot inventorySlot, ItemStack toOutput, int operations) {
        if (operations == 0 || toOutput.isEmpty()) {
            return;
        }
        ItemStack output = toOutput.copy();
        if (operations > 1) {
            output.setCount(output.getCount() * operations);
        }
        inventorySlot.insertItem(output, Action.EXECUTE, AutomationType.INTERNAL);
    }

    private static void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, CachedRecipe.OperationTracker.RecipeError notEnoughSpace, IInventorySlot slot, ItemStack toOutput, IntSupplier baselineMaxOperations) {
        if (!toOutput.isEmpty()) {
            ItemStack output = toOutput.copyWithCount(Math.max(toOutput.getMaxStackSize(), baselineMaxOperations.getAsInt()));
            ItemStack remainder = slot.insertItem(output, Action.SIMULATE, AutomationType.INTERNAL);
            int amountUsed = output.getCount() - remainder.getCount();
            int operations = amountUsed / toOutput.getCount();
            tracker.updateOperations(operations);
            if (operations == 0) {
                if (amountUsed == 0 && slot.getLimit(slot.getStack()) - slot.getCount() > 0) {
                    tracker.addError(CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
                } else {
                    tracker.addError(notEnoughSpace);
                }
            }
        }
    }
}

