/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.client.model;

import com.jerry.mekextras.api.tier.AdvancedTier;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mekanism.api.SupportsColorMap;
import mekanism.client.model.MekanismJavaModel;
import mekanism.client.model.ModelPartData;
import mekanism.client.render.MekanismRenderType;
import mekanism.common.Mekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;

public class ColorModelEnergyCore
extends MekanismJavaModel {
    public static final ModelLayerLocation CORE_LAYER = new ModelLayerLocation(Mekanism.rl((String)"energy_core"), "main");
    private static final ResourceLocation CORE_TEXTURE = MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.RENDER, (String)"energy_core.png");
    private static final ModelPartData CUBE = new ModelPartData("cube", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), new ModelPartData[0]);
    public static final RenderType BATCHED_RENDER_TYPE = (RenderType)MekanismRenderType.STANDARD_TRANSLUCENT_TARGET.apply(CORE_TEXTURE);
    public final RenderType RENDER_TYPE = this.renderType(CORE_TEXTURE);
    private final ModelPart cube;

    public static LayerDefinition createLayerDefinition() {
        return ColorModelEnergyCore.createLayerDefinition((int)32, (int)32, (ModelPartData[])new ModelPartData[]{CUBE});
    }

    public ColorModelEnergyCore(EntityModelSet entityModelSet) {
        super(MekanismRenderType.STANDARD);
        ModelPart root = entityModelSet.bakeLayer(CORE_LAYER);
        this.cube = CUBE.getFromRoot(root);
    }

    public void render(@NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, AdvancedTier advancedTier, float energyPercentage) {
        this.render(matrix, renderer.getBuffer(this.RENDER_TYPE), light, overlayLight, (SupportsColorMap)advancedTier, energyPercentage);
    }

    public void render(@NotNull PoseStack matrix, @NotNull VertexConsumer buffer, int light, int overlayLight, SupportsColorMap color, float energyPercentage) {
        this.renderToBuffer(matrix, buffer, light, overlayLight, color.getPackedColor(FastColor.as8BitChannel((float)energyPercentage)));
    }

    public void renderToBuffer(@NotNull PoseStack matrix, @NotNull VertexConsumer vertexBuilder, int light, int overlayLight, int color) {
        this.cube.render(matrix, vertexBuilder, light, overlayLight, color);
    }
}

