/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.client.model.energycube;

import com.jerry.mekextras.client.model.energycube.ExtraEnergyCubeBakedModel;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import mekanism.api.RelativeSide;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraEnergyCubeGeometry
implements IUnbakedGeometry<ExtraEnergyCubeGeometry> {
    private final List<BlockElement> frame;
    private final Map<RelativeSide, List<BlockElement>> leds;
    private final Map<RelativeSide, List<BlockElement>> ports;

    ExtraEnergyCubeGeometry(List<BlockElement> frame, Map<RelativeSide, List<BlockElement>> leds, Map<RelativeSide, List<BlockElement>> ports) {
        this.frame = frame;
        this.leds = leds;
        this.ports = ports;
    }

    @NotNull
    public BakedModel bake(IGeometryBakingContext context, @NotNull ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, @NotNull ModelState modelState, @NotNull ItemOverrides overrides) {
        TextureAtlasSprite particle = spriteGetter.apply(context.getMaterial("particle"));
        ResourceLocation renderTypeHint = context.getRenderTypeHint();
        RenderTypeGroup renderTypes = renderTypeHint == null ? RenderTypeGroup.EMPTY : context.getRenderType(renderTypeHint);
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = new SimpleModelState(modelState.getRotation().compose(rootTransform), modelState.isUvLocked());
        }
        Function<String, TextureAtlasSprite> rawSpriteGetter = spriteGetter.compose(arg_0 -> ((IGeometryBakingContext)context).getMaterial(arg_0));
        FaceData frame = this.bakeElement(rawSpriteGetter, modelState, this.frame);
        Map<RelativeSide, FaceData> leds = this.bakeElements(rawSpriteGetter, modelState, this.leds);
        Map<RelativeSide, FaceData> ports = this.bakeElements(rawSpriteGetter, modelState, this.ports);
        return new ExtraEnergyCubeBakedModel(context.useAmbientOcclusion(), context.useBlockLight(), context.isGui3d(), context.getTransforms(), overrides, particle, frame, leds, ports, renderTypes);
    }

    private Map<RelativeSide, FaceData> bakeElements(Function<String, TextureAtlasSprite> spriteGetter, ModelState modelState, Map<RelativeSide, List<BlockElement>> sideBasedElements) {
        EnumMap<RelativeSide, FaceData> sideBasedFaceData = new EnumMap<RelativeSide, FaceData>(RelativeSide.class);
        for (Map.Entry<RelativeSide, List<BlockElement>> entry : sideBasedElements.entrySet()) {
            FaceData faceData = this.bakeElement(spriteGetter, modelState, entry.getValue());
            sideBasedFaceData.put(entry.getKey(), faceData);
        }
        return sideBasedFaceData;
    }

    private FaceData bakeElement(Function<String, TextureAtlasSprite> spriteGetter, ModelState modelState, List<BlockElement> elements) {
        FaceData data = new FaceData();
        for (BlockElement element : elements) {
            for (Map.Entry faceEntry : element.faces.entrySet()) {
                BlockElementFace face = (BlockElementFace)faceEntry.getValue();
                TextureAtlasSprite sprite = spriteGetter.apply(face.texture());
                Direction direction = face.cullForDirection() == null ? null : modelState.getRotation().rotateTransform(face.cullForDirection());
                data.addFace(direction, BlockModel.bakeFace((BlockElement)element, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)((Direction)faceEntry.getKey()), (ModelState)modelState));
            }
        }
        return data;
    }

    static class FaceData {
        private List<BakedQuad> unculledFaces;
        private Map<Direction, List<BakedQuad>> culledFaces;

        FaceData() {
        }

        public List<BakedQuad> getFaces(@Nullable Direction side) {
            if (side == null) {
                return this.unculledFaces == null ? Collections.emptyList() : this.unculledFaces;
            }
            return this.culledFaces == null ? Collections.emptyList() : this.culledFaces.getOrDefault(side, Collections.emptyList());
        }

        public void addFace(@Nullable Direction direction, BakedQuad quad) {
            List quads;
            if (direction == null) {
                if (this.unculledFaces == null) {
                    this.unculledFaces = new ArrayList<BakedQuad>();
                }
                quads = this.unculledFaces;
            } else {
                if (this.culledFaces == null) {
                    this.culledFaces = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
                }
                quads = this.culledFaces.computeIfAbsent(direction, dir -> new ArrayList());
            }
            quads.add((BakedQuad)quad);
        }

        public FaceData transform(QuadTransformation transformation) {
            if (this.unculledFaces == null && this.culledFaces == null) {
                return this;
            }
            FaceData transformed = new FaceData();
            if (this.unculledFaces != null) {
                transformed.unculledFaces = QuadUtils.transformBakedQuads(this.unculledFaces, (QuadTransformation)transformation);
            }
            if (this.culledFaces != null) {
                transformed.culledFaces = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
                for (Map.Entry<Direction, List<BakedQuad>> entry : this.culledFaces.entrySet()) {
                    transformed.culledFaces.put(entry.getKey(), QuadUtils.transformBakedQuads(entry.getValue(), (QuadTransformation)transformation));
                }
            }
            return transformed;
        }
    }
}

