/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.client.render.tileentity;

import com.jerry.mekextras.common.inventory.slot.ExtraBinInventorySlot;
import com.jerry.mekextras.common.tile.ExtraTileEntityBin;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.Optional;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.util.WorldUtils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ExtraRenderBin
extends MekanismTileEntityRenderer<ExtraTileEntityBin> {
    private static final Matrix3f FAKE_NORMALS = (Matrix3f)Util.make(() -> {
        Vector3f NORMAL = new Vector3f(1.0f, 1.0f, 1.0f);
        NORMAL.normalize();
        return new Matrix3f().set((Quaternionfc)new Quaternionf().setAngleAxis(0.0f, NORMAL.x, NORMAL.y, NORMAL.z));
    });

    public ExtraRenderBin(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void render(ExtraTileEntityBin tile, float partialTick, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, @NotNull ProfilerFiller profiler) {
        Level world = tile.getLevel();
        ExtraBinInventorySlot binSlot = tile.getBinSlot();
        if (world != null && (!binSlot.isEmpty() || binSlot.isLocked())) {
            Direction facing = tile.getDirection();
            BlockPos coverPos = tile.getBlockPos().relative(facing);
            Optional blockState = WorldUtils.getBlockState((BlockGetter)world, (BlockPos)coverPos);
            if (blockState.isEmpty() || !((BlockState)blockState.get()).canOcclude() || !((BlockState)blockState.get()).isFaceSturdy((BlockGetter)world, coverPos, facing.getOpposite())) {
                matrix.pushPose();
                matrix.last().normal().set((Matrix3fc)FAKE_NORMALS);
                switch (facing) {
                    case NORTH: {
                        matrix.translate(0.71, 0.8, -1.0E-4);
                        matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
                        break;
                    }
                    case SOUTH: {
                        matrix.translate(0.29, 0.8, 1.0001);
                        break;
                    }
                    case WEST: {
                        matrix.translate(-1.0E-4, 0.8, 0.29);
                        matrix.mulPose(Axis.YP.rotationDegrees(-90.0f));
                        break;
                    }
                    case EAST: {
                        matrix.translate(1.0001, 0.8, 0.71);
                        matrix.mulPose(Axis.YP.rotationDegrees(90.0f));
                    }
                }
                float scale = 0.025f;
                matrix.scale(scale, scale, 1.0E-4f);
                matrix.translate(8.0f, -8.0f, 8.0f);
                matrix.scale(16.0f, 16.0f, 16.0f);
                light = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)tile.getBlockPos().relative(facing));
                Minecraft.getInstance().getItemRenderer().renderStatic(binSlot.getRenderStack(), ItemDisplayContext.GUI, light, overlayLight, matrix, renderer, world, MathUtils.clampToInt((long)tile.getBlockPos().asLong()));
                matrix.popPose();
                this.renderText(matrix, renderer, light, overlayLight, this.getCount(tile), facing, 0.02f);
            }
        }
    }

    protected Component getCount(ExtraTileEntityBin bin) {
        ExtraBinInventorySlot slot = bin.getBinSlot();
        return TextComponentUtil.build((Object[])new Object[]{slot.isLocked() ? EnumColor.AQUA : EnumColor.WHITE, slot.getCount()});
    }

    @NotNull
    protected String getProfilerSection() {
        return "bin";
    }

    private void renderText(@NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, Component text, Direction side, float maxScale) {
        matrix.pushPose();
        matrix.translate(0.0, -0.25, 0.0);
        switch (side) {
            case SOUTH: {
                matrix.translate(0.0f, 1.0f, 0.0f);
                matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case NORTH: {
                matrix.translate(1.0f, 1.0f, 1.0f);
                matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
                matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                matrix.translate(0.0f, 1.0f, 1.0f);
                matrix.mulPose(Axis.YP.rotationDegrees(90.0f));
                matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                matrix.translate(1.0f, 1.0f, 0.0f);
                matrix.mulPose(Axis.YP.rotationDegrees(-90.0f));
                matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
        }
        float displayWidth = 1.0f;
        float displayHeight = 1.0f;
        matrix.translate(displayWidth / 2.0f, 1.0f, displayHeight / 2.0f);
        matrix.mulPose(Axis.XP.rotationDegrees(-90.0f));
        Font font = this.context.getFont();
        int requiredWidth = Math.max(font.width((FormattedText)text), 1);
        Objects.requireNonNull(font);
        int requiredHeight = 9 + 2;
        float scaler = 0.4f;
        float scaleX = displayWidth / (float)requiredWidth;
        float scale = scaleX * scaler;
        if (maxScale > 0.0f) {
            scale = Math.min(scale, maxScale);
        }
        matrix.scale(scale, -scale, scale);
        int realHeight = Mth.floor((float)(displayHeight / scale));
        int realWidth = Mth.floor((float)(displayWidth / scale));
        int offsetX = (realWidth - requiredWidth) / 2;
        int offsetY = (realHeight - requiredHeight) / 2;
        font.drawInBatch(text, (float)(offsetX - realWidth / 2), (float)(1 + offsetY - realHeight / 2), overlayLight, false, matrix.last().pose(), renderer, Font.DisplayMode.POLYGON_OFFSET, 0, light);
        matrix.popPose();
    }
}

