/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.attachments.containers.item;

import com.jerry.mekextras.common.inventory.slot.ExtraBinInventorySlot;
import com.jerry.mekextras.common.item.block.ExtraItemBlockBin;
import com.jerry.mekextras.common.tier.BTier;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.attachments.LockData;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.IAttachedContainers;
import mekanism.common.attachments.containers.item.AttachedItems;
import mekanism.common.attachments.containers.item.ComponentBackedInventorySlot;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class ExtraComponentBackedBinInventorySlot
extends ComponentBackedInventorySlot {
    private final boolean isCreative;

    public static ExtraComponentBackedBinInventorySlot create(ContainerType<?, ?, ?> ignored, ItemStack attachedTo, int tankIndex) {
        Item item = attachedTo.getItem();
        if (!(item instanceof ExtraItemBlockBin)) {
            throw new IllegalStateException("Attached to should always be a bin item");
        }
        ExtraItemBlockBin item2 = (ExtraItemBlockBin)item;
        return new ExtraComponentBackedBinInventorySlot(attachedTo, tankIndex, item2.getAdvanceTier());
    }

    private ExtraComponentBackedBinInventorySlot(ItemStack attachedTo, int slotIndex, BTier tier) {
        super(attachedTo, slotIndex, ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrueBi(), ExtraBinInventorySlot.validator);
        this.isCreative = false;
    }

    @NotNull
    public ItemStack insertItem(@NotNull AttachedItems attachedItems, ItemStack current, @NotNull ItemStack stack, @NotNull Action action, @NotNull AutomationType automationType) {
        if (current.isEmpty()) {
            ItemStack lockStack = this.getLockStack();
            if (!lockStack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)lockStack, (ItemStack)stack)) {
                return stack;
            }
            if (this.isCreative && action.execute() && automationType != AutomationType.EXTERNAL) {
                ItemStack simulatedRemainder = super.insertItem(attachedItems, current, stack, Action.SIMULATE, automationType);
                if (simulatedRemainder.isEmpty()) {
                    this.setContents((IAttachedContainers)attachedItems, stack.copyWithCount(this.getLimit(stack)));
                }
                return simulatedRemainder;
            }
        }
        return super.insertItem(attachedItems, current, stack, action.combine(!this.isCreative), automationType);
    }

    @NotNull
    public ItemStack extractItem(int amount, Action action, @NotNull AutomationType automationType) {
        return super.extractItem(amount, action.combine(!this.isCreative), automationType);
    }

    protected int setStackSize(@NotNull AttachedItems attachedItems, @NotNull ItemStack current, int amount, Action action) {
        return super.setStackSize(attachedItems, current, amount, action.combine(!this.isCreative));
    }

    public ItemStack getBottomStack() {
        ItemStack current = this.getStack();
        if (current.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return current.copyWithCount(Math.min(current.getCount(), current.getMaxStackSize()));
    }

    public void setLockStack(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            this.attachedTo.remove((Supplier)MekanismDataComponents.LOCK);
        } else {
            this.attachedTo.set((Supplier)MekanismDataComponents.LOCK, (Object)new LockData(stack.copyWithCount(1)));
        }
    }

    public ItemStack getLockStack() {
        return ((LockData)this.attachedTo.getOrDefault((Supplier)MekanismDataComponents.LOCK, (Object)LockData.EMPTY)).lock();
    }

    @NotNull
    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = super.serializeNBT(provider);
        ItemStack lockStack = this.getLockStack();
        if (!lockStack.isEmpty()) {
            nbt.put("lock_stack", lockStack.save(provider));
        }
        return nbt;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        NBTUtils.setItemStackOrEmpty((HolderLookup.Provider)provider, (CompoundTag)nbt, (String)"lock_stack", this::setLockStack);
        super.deserializeNBT(provider, nbt);
    }
}

