/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.content.matrix;

import com.jerry.mekextras.common.content.matrix.ReinforcedMatrixMultiblockData;
import com.jerry.mekextras.common.registries.ExtraBlockTypes;
import com.jerry.mekextras.common.tile.multiblock.ExtraTileEntityInductionCell;
import com.jerry.mekextras.common.tile.multiblock.ExtraTileEntityInductionProvider;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public class ReinforcedMatrixValidator
extends CuboidStructureValidator<ReinforcedMatrixMultiblockData> {
    private final List<ExtraTileEntityInductionCell> cells = new ArrayList<ExtraTileEntityInductionCell>();
    private final List<ExtraTileEntityInductionProvider> providers = new ArrayList<ExtraTileEntityInductionProvider>();

    protected FormationProtocol.CasingType getCasingType(BlockState state) {
        Block block = state.getBlock();
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{ExtraBlockTypes.REINFORCED_INDUCTION_CASING})) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{ExtraBlockTypes.REINFORCED_INDUCTION_PORT})) {
            return FormationProtocol.CasingType.VALVE;
        }
        return FormationProtocol.CasingType.INVALID;
    }

    public boolean validateInner(BlockState state, Long2ObjectMap<ChunkAccess> chunkMap, BlockPos pos) {
        if (super.validateInner(state, chunkMap, pos)) {
            return true;
        }
        if (BlockType.is((Block)state.getBlock(), (BlockType[])new BlockType[]{ExtraBlockTypes.ABSOLUTE_INDUCTION_CELL, ExtraBlockTypes.SUPREME_INDUCTION_CELL, ExtraBlockTypes.COSMIC_INDUCTION_CELL, ExtraBlockTypes.INFINITE_INDUCTION_CELL, ExtraBlockTypes.ABSOLUTE_INDUCTION_PROVIDER, ExtraBlockTypes.SUPREME_INDUCTION_PROVIDER, ExtraBlockTypes.COSMIC_INDUCTION_PROVIDER, ExtraBlockTypes.INFINITE_INDUCTION_PROVIDER})) {
            BlockEntity tile = WorldUtils.getTileEntity((LevelAccessor)this.world, chunkMap, (BlockPos)pos);
            if (tile instanceof ExtraTileEntityInductionCell) {
                ExtraTileEntityInductionCell cell = (ExtraTileEntityInductionCell)tile;
                this.cells.add(cell);
                return true;
            }
            if (tile instanceof ExtraTileEntityInductionProvider) {
                ExtraTileEntityInductionProvider provider = (ExtraTileEntityInductionProvider)tile;
                this.providers.add(provider);
                return true;
            }
        }
        return false;
    }

    public FormationProtocol.FormationResult postcheck(ReinforcedMatrixMultiblockData structure, Long2ObjectMap<ChunkAccess> chunkMap) {
        for (ExtraTileEntityInductionCell cell : this.cells) {
            structure.addCell(cell);
        }
        for (ExtraTileEntityInductionProvider provider : this.providers) {
            structure.addProvider(provider);
        }
        return FormationProtocol.FormationResult.SUCCESS;
    }
}

