/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.integration;

import com.jerry.genextras.common.config.GeneratorsExtraConfig;
import com.jerry.genextras.common.registries.GenExtraBlocks;
import com.jerry.genextras.common.registries.GenExtraChemicals;
import com.jerry.genextras.common.registries.GenExtraContainerTypes;
import com.jerry.genextras.common.registries.GenExtraDataComponents;
import com.jerry.genextras.common.registries.GenExtraFluids;
import com.jerry.genextras.common.registries.GenExtraItems;
import com.jerry.genextras.common.registries.GenExtraTileEntityTypes;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;

public class ExtraHooks {
    public final IntegrationInfo mekanismGenerators;
    public final IntegrationInfo evolvedMekanism;

    public ExtraHooks() {
        ModList modList = ModList.get();
        Predicate<String> loadedCheck = modList == null ? modid -> false : arg_0 -> ((ModList)modList).isLoaded(arg_0);
        this.mekanismGenerators = new IntegrationInfo("mekanismgenerators", loadedCheck);
        this.evolvedMekanism = new IntegrationInfo("evolvedmekanism", loadedCheck);
    }

    public void hookConstructor(ModContainer modContainer, IEventBus modEventBus) {
        if (this.mekanismGenerators.isLoaded()) {
            GeneratorsExtraConfig.registerConfigs(modContainer);
            GenExtraItems.GEN_EXTRA_ITEMS.register(modEventBus);
            GenExtraBlocks.GEN_EXTRA_BLOCKS.register(modEventBus);
            GenExtraFluids.GEN_EXTRA_FLUIDS.register(modEventBus);
            GenExtraDataComponents.GEN_EXTRA_DATA_COMPONENTS.register(modEventBus);
            GenExtraContainerTypes.GEN_EXTRA_CONTAINER_TYPE.register(modEventBus);
            GenExtraTileEntityTypes.GEN_EXTRA_TILE_ENTITY_TYPES.register(modEventBus);
            GenExtraChemicals.EXTRA_GEN_CHEMICALS.register(modEventBus);
        }
    }

    public record IntegrationInfo(String modid, boolean isLoaded) {
        private IntegrationInfo(String modid, Predicate<String> loadedCheck) {
            this(modid, loadedCheck.test(modid));
        }

        private void sendImc(String method, Supplier<?> toSend) {
            InterModComms.sendTo((String)this.modid, (String)method, toSend);
        }

        public ResourceLocation rl(String path) {
            return ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path);
        }

        public void assertLoaded() {
            if (!this.isLoaded) {
                throw new IllegalStateException(this.modid + " is not loaded");
            }
        }
    }
}

