/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.inventory.slot;

import com.jerry.mekextras.common.tier.ExtraFactoryTier;
import java.util.Objects;
import java.util.function.Predicate;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.InputInventorySlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class StackableInputInventorySlot
extends InputInventorySlot {
    private static ExtraFactoryTier isTier = ExtraFactoryTier.ABSOLUTE;

    public static StackableInputInventorySlot at(ExtraFactoryTier tier, Predicate<@NotNull ItemStack> isItemValid, @Nullable IContentsListener listener, int x, int y) {
        return StackableInputInventorySlot.at(tier, ConstantPredicates.alwaysTrue(), isItemValid, listener, x, y);
    }

    public static StackableInputInventorySlot at(ExtraFactoryTier tier, Predicate<@NotNull ItemStack> insertPredicate, Predicate<@NotNull ItemStack> isItemValid, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(insertPredicate, "Insertion check cannot be null");
        Objects.requireNonNull(isItemValid, "Item validity check cannot be null");
        return new StackableInputInventorySlot(tier, insertPredicate, isItemValid, listener, x, y);
    }

    protected StackableInputInventorySlot(ExtraFactoryTier tier, Predicate<@NotNull ItemStack> insertPredicate, Predicate<@NotNull ItemStack> isItemValid, @Nullable IContentsListener listener, int x, int y) {
        super(insertPredicate, isItemValid, listener, x, y);
        isTier = tier;
        this.setSlotType(ContainerSlotType.EXTRA);
    }

    public int getLimit(ItemStack stack) {
        int process = super.getLimit(stack) * StackableInputInventorySlot.isTier.processes;
        return switch (isTier) {
            default -> throw new MatchException(null, null);
            case ExtraFactoryTier.ABSOLUTE -> process * 8;
            case ExtraFactoryTier.SUPREME -> process * 16;
            case ExtraFactoryTier.COSMIC -> process * 32;
            case ExtraFactoryTier.INFINITE -> process * 64;
        };
    }
}

