/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.inventory.slot.chemical;

import com.jerry.mekextras.common.tier.ExtraFactoryTier;
import com.jerry.mekextras.common.tile.factory.TileEntityExtraFactory;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ExtraFactoryChemicalInventorySlot
extends ChemicalInventorySlot {
    private final TileEntityExtraFactory<?> factory;

    protected ExtraFactoryChemicalInventorySlot(TileEntityExtraFactory<?> factory, IChemicalTank chemicalTank, Supplier<Level> worldSupplier, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, @Nullable IContentsListener listener, int x, int y) {
        super(chemicalTank, worldSupplier, canExtract, canInsert, ConstantPredicates.alwaysTrue(), listener, x, y);
        this.factory = factory;
    }

    public static ExtraFactoryChemicalInventorySlot fillOrConverts(TileEntityExtraFactory<?> factory, IChemicalTank gasTank, Supplier<Level> worldSupplier, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        Objects.requireNonNull(worldSupplier, "World supplier cannot be null");
        return new ExtraFactoryChemicalInventorySlot(factory, gasTank, worldSupplier, ExtraFactoryChemicalInventorySlot.getFillOrConvertExtractPredicate(gasTank, worldSupplier), ExtraFactoryChemicalInventorySlot.getFillOrConvertInsertPredicate(gasTank, worldSupplier), listener, x, y);
    }

    private static Predicate<@NotNull ItemStack> getFillOrConvertExtractPredicate(IChemicalTank chemicalTank, Supplier<Level> levelSupplier) {
        return stack -> {
            ChemicalStack conversion;
            IChemicalHandler handler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
            if (handler != null) {
                for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
                    if (!chemicalTank.isValid(handler.getChemicalInTank(tank))) continue;
                    return false;
                }
            }
            return (conversion = ExtraFactoryChemicalInventorySlot.getPotentialConversion((Level)((Level)levelSupplier.get()), (ItemStack)stack)).isEmpty() || !chemicalTank.isValid(conversion);
        };
    }

    private static Predicate<@NotNull ItemStack> getFillOrConvertInsertPredicate(IChemicalTank chemicalTank, Supplier<Level> levelSupplier) {
        return stack -> {
            if (ExtraFactoryChemicalInventorySlot.fillInsertCheck((IChemicalTank)chemicalTank, (ItemStack)stack)) {
                return true;
            }
            ChemicalStack conversion = ExtraFactoryChemicalInventorySlot.getPotentialConversion((Level)((Level)levelSupplier.get()), (ItemStack)stack);
            if (conversion.isEmpty()) {
                return false;
            }
            if (chemicalTank.insert(conversion, Action.SIMULATE, AutomationType.INTERNAL).getAmount() < conversion.getAmount()) {
                return true;
            }
            return chemicalTank.getNeeded() == 0L && chemicalTank.isTypeEqual(conversion) && chemicalTank.isValid(conversion);
        };
    }

    public int getLimit(ItemStack stack) {
        if (!stack.isEmpty() && Capabilities.CHEMICAL.hasCapability(stack)) {
            return super.getLimit(stack);
        }
        int processes = this.factory.tier.processes;
        return switch (this.factory.tier) {
            default -> throw new MatchException(null, null);
            case ExtraFactoryTier.ABSOLUTE -> super.getLimit(stack) * 8 * processes;
            case ExtraFactoryTier.SUPREME -> super.getLimit(stack) * 16 * processes;
            case ExtraFactoryTier.COSMIC -> super.getLimit(stack) * 32 * processes;
            case ExtraFactoryTier.INFINITE -> super.getLimit(stack) * 64 * processes;
        };
    }
}

