/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.item.block.transmitter;

import com.jerry.mekextras.common.item.block.transmitter.ExtraItemBlockTransporter;
import com.jerry.mekextras.common.tier.transmitter.TPTier;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityLogisticalTransporter;
import java.util.List;
import java.util.Objects;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.transmitter.BlockLargeTransmitter;
import mekanism.common.tier.TransporterTier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraItemBlockLogisticalTransporter
extends ExtraItemBlockTransporter<ExtraTileEntityLogisticalTransporter> {
    public ExtraItemBlockLogisticalTransporter(BlockLargeTransmitter<ExtraTileEntityLogisticalTransporter> block, Item.Properties properties) {
        super(block, properties);
    }

    @NotNull
    public TransporterTier getTier() {
        return Objects.requireNonNull((TransporterTier)Attribute.getTier((Block)this.getBlock(), TransporterTier.class));
    }

    protected void addStats(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.addStats(stack, context, tooltip, flag);
        TransporterTier tier = this.getTier();
        float tickRate = Math.max(context.tickRate(), 1.0f);
        float speed = (float)TPTier.getSpeed(tier) / (100.0f / tickRate);
        float pull = (float)TPTier.getPullAmount(tier) * tickRate / 10.0f;
        tooltip.add((Component)MekanismLang.SPEED.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, Float.valueOf(speed)}));
        tooltip.add((Component)MekanismLang.PUMP_RATE.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, Float.valueOf(pull)}));
    }
}

