/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.item.block.transmitter;

import com.jerry.mekextras.common.tier.transmitter.PTier;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityMechanicalPipe;
import java.util.List;
import java.util.Objects;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.transmitter.BlockLargeTransmitter;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.tier.PipeTier;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraItemBlockMechanicalPipe
extends ItemBlockTooltip<BlockLargeTransmitter<ExtraTileEntityMechanicalPipe>> {
    public ExtraItemBlockMechanicalPipe(BlockLargeTransmitter<ExtraTileEntityMechanicalPipe> block, Item.Properties properties) {
        super(block, true, properties);
    }

    @NotNull
    public PipeTier getTier() {
        return Objects.requireNonNull((PipeTier)Attribute.getTier((Block)this.getBlock(), PipeTier.class));
    }

    protected void addDetails(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.addDetails(stack, context, tooltip, flag);
        tooltip.add((Component)MekanismLang.CAPABLE_OF_TRANSFERRING.translateColored(EnumColor.DARK_GRAY));
        tooltip.add((Component)MekanismLang.FLUIDS.translateColored(EnumColor.PURPLE, new Object[]{EnumColor.GRAY, MekanismLang.FORGE}));
    }

    protected void addStats(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.addStats(stack, context, tooltip, flag);
        PipeTier tier = this.getTier();
        tooltip.add((Component)MekanismLang.CAPACITY_MB_PER_TICK.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, TextUtils.format((long)PTier.getPipeCapacity(tier))}));
        tooltip.add((Component)MekanismLang.PUMP_RATE_MB.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, TextUtils.format((long)PTier.getPipePullAmount(tier))}));
    }
}

