/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.item.block.transmitter;

import com.jerry.mekextras.common.tier.transmitter.TTier;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityPressurizedTube;
import java.util.List;
import java.util.Objects;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.transmitter.BlockSmallTransmitter;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.tier.TubeTier;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraItemBlockPressurizedTube
extends ItemBlockTooltip<BlockSmallTransmitter<ExtraTileEntityPressurizedTube>> {
    public ExtraItemBlockPressurizedTube(BlockSmallTransmitter<ExtraTileEntityPressurizedTube> block, Item.Properties properties) {
        super(block, true, properties);
    }

    @NotNull
    public TubeTier getTier() {
        return Objects.requireNonNull((TubeTier)Attribute.getTier((Block)this.getBlock(), TubeTier.class));
    }

    protected void addDetails(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.addDetails(stack, context, tooltip, flag);
        tooltip.add((Component)MekanismLang.CAPABLE_OF_TRANSFERRING.translateColored(EnumColor.DARK_GRAY));
        tooltip.add((Component)MekanismLang.CHEMICAL.translateColored(EnumColor.PURPLE, new Object[]{MekanismLang.MEKANISM}));
    }

    protected void addStats(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.addStats(stack, context, tooltip, flag);
        TubeTier tier = this.getTier();
        tooltip.add((Component)MekanismLang.CAPACITY_MB_PER_TICK.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, TextUtils.format((long)TTier.getTubeCapacity(tier))}));
        tooltip.add((Component)MekanismLang.PUMP_RATE_MB.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, TextUtils.format((long)TTier.getTubePullAmount(tier))}));
    }
}

