/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.item.block.transmitter;

import com.jerry.mekextras.common.tier.transmitter.TCTier;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityThermodynamicConductor;
import java.util.List;
import java.util.Objects;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.transmitter.BlockSmallTransmitter;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.tier.ConductorTier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraItemBlockThermodynamicConductor
extends ItemBlockTooltip<BlockSmallTransmitter<ExtraTileEntityThermodynamicConductor>> {
    public ExtraItemBlockThermodynamicConductor(BlockSmallTransmitter<ExtraTileEntityThermodynamicConductor> block, Item.Properties properties) {
        super(block, true, properties);
    }

    @NotNull
    public ConductorTier getTier() {
        return Objects.requireNonNull((ConductorTier)Attribute.getTier((Block)this.getBlock(), ConductorTier.class));
    }

    protected void addDetails(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.addDetails(stack, context, tooltip, flag);
        tooltip.add((Component)MekanismLang.CAPABLE_OF_TRANSFERRING.translateColored(EnumColor.DARK_GRAY));
        tooltip.add((Component)MekanismLang.HEAT.translateColored(EnumColor.PURPLE, new Object[]{MekanismLang.MEKANISM}));
    }

    protected void addStats(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.addStats(stack, context, tooltip, flag);
        ConductorTier tier = this.getTier();
        tooltip.add((Component)MekanismLang.CONDUCTION.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, TCTier.getConduction(tier)}));
        tooltip.add((Component)MekanismLang.INSULATION.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, TCTier.getConductionInsulation(tier)}));
        tooltip.add((Component)MekanismLang.HEAT_CAPACITY.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, TCTier.getHeatCapacity(tier)}));
    }
}

