/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekextras.common.block.ExtraBlockEnergyCube;
import com.jerry.mekextras.common.block.basic.ExtraBlockBin;
import com.jerry.mekextras.common.block.basic.ExtraBlockFluidTank;
import com.jerry.mekextras.common.block.prefab.BlockExtraFactoryMachine;
import com.jerry.mekextras.common.capabilities.ExtraCapabilities;
import com.jerry.mekextras.common.item.block.ExtraItemBlockBin;
import com.jerry.mekextras.common.item.block.ExtraItemBlockChemicalTank;
import com.jerry.mekextras.common.item.block.ExtraItemBlockEnergyCube;
import com.jerry.mekextras.common.item.block.ItemBlockLargeCapRadioactiveWasteBarrel;
import com.jerry.mekextras.common.item.block.machine.ExtraItemBlockFluidTank;
import com.jerry.mekextras.common.item.block.machine.ItemBlockExtraFactory;
import com.jerry.mekextras.common.registries.ExtraBlocks;
import com.jerry.mekextras.common.tier.ExtraFactoryTier;
import com.jerry.mekextras.common.tile.ExtraTileEntityBin;
import com.jerry.mekextras.common.tile.ExtraTileEntityChemicalTank;
import com.jerry.mekextras.common.tile.ExtraTileEntityEnergyCube;
import com.jerry.mekextras.common.tile.ExtraTileEntityFluidTank;
import com.jerry.mekextras.common.tile.TileEntityLargeCapRadioactiveWasteBarrel;
import com.jerry.mekextras.common.tile.factory.TileEntityCombiningExtraFactory;
import com.jerry.mekextras.common.tile.factory.TileEntityExtraFactory;
import com.jerry.mekextras.common.tile.factory.TileEntityItemStackChemicalToItemStackExtraFactory;
import com.jerry.mekextras.common.tile.factory.TileEntityItemStackToItemStackExtraFactory;
import com.jerry.mekextras.common.tile.factory.TileEntitySawingExtraFactory;
import com.jerry.mekextras.common.tile.machine.TileEntityAdvancedElectricPump;
import com.jerry.mekextras.common.tile.multiblock.ExtraTileEntityInductionCell;
import com.jerry.mekextras.common.tile.multiblock.ExtraTileEntityInductionProvider;
import com.jerry.mekextras.common.tile.multiblock.TileEntityReinforcedInductionCasing;
import com.jerry.mekextras.common.tile.multiblock.TileEntityReinforcedInductionPort;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityLogisticalTransporter;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityLogisticalTransporterBase;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityMechanicalPipe;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityPressurizedTube;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityThermodynamicConductor;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityTransmitter;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityUniversalCable;
import com.jerry.mekextras.common.util.ExtraEnumUtils;
import java.util.function.BooleanSupplier;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.integration.computer.ComputerCapabilityHelper;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeDeferredRegister;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tile.base.CapabilityTileEntity;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.BlockCapability;

public class ExtraTileEntityTypes {
    public static final TileEntityTypeDeferredRegister EXTRA_TILE_ENTITY_TYPES = new TileEntityTypeDeferredRegister("mekanism_extras");
    private static final Table<ExtraFactoryTier, FactoryType, TileEntityTypeRegistryObject<? extends TileEntityExtraFactory<?>>> FACTORIES = HashBasedTable.create();
    public static final TileEntityTypeRegistryObject<TileEntityAdvancedElectricPump> ADVANCED_ELECTRIC_PUMP;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityBin> ABSOLUTE_BIN;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityBin> SUPREME_BIN;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityBin> COSMIC_BIN;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityBin> INFINITE_BIN;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityEnergyCube> ABSOLUTE_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityEnergyCube> SUPREME_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityEnergyCube> COSMIC_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityEnergyCube> INFINITE_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityFluidTank> ABSOLUTE_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityFluidTank> SUPREME_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityFluidTank> COSMIC_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityFluidTank> INFINITE_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityChemicalTank> ABSOLUTE_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityChemicalTank> SUPREME_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityChemicalTank> COSMIC_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityChemicalTank> INFINITE_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityLargeCapRadioactiveWasteBarrel> ABSOLUTE_RADIOACTIVE_WASTE_BARREL;
    public static final TileEntityTypeRegistryObject<TileEntityLargeCapRadioactiveWasteBarrel> SUPREME_RADIOACTIVE_WASTE_BARREL;
    public static final TileEntityTypeRegistryObject<TileEntityLargeCapRadioactiveWasteBarrel> COSMIC_RADIOACTIVE_WASTE_BARREL;
    public static final TileEntityTypeRegistryObject<TileEntityLargeCapRadioactiveWasteBarrel> INFINITE_RADIOACTIVE_WASTE_BARREL;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityUniversalCable> ABSOLUTE_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityUniversalCable> SUPREME_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityUniversalCable> COSMIC_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityUniversalCable> INFINITE_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityMechanicalPipe> ABSOLUTE_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityMechanicalPipe> SUPREME_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityMechanicalPipe> COSMIC_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityMechanicalPipe> INFINITE_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityPressurizedTube> ABSOLUTE_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityPressurizedTube> SUPREME_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityPressurizedTube> COSMIC_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityPressurizedTube> INFINITE_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityLogisticalTransporter> ABSOLUTE_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityLogisticalTransporter> SUPREME_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityLogisticalTransporter> COSMIC_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityLogisticalTransporter> INFINITE_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityThermodynamicConductor> ABSOLUTE_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityThermodynamicConductor> SUPREME_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityThermodynamicConductor> COSMIC_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityThermodynamicConductor> INFINITE_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<TileEntityReinforcedInductionCasing> REINFORCED_INDUCTION_CASING;
    public static final TileEntityTypeRegistryObject<TileEntityReinforcedInductionPort> REINFORCED_INDUCTION_PORT;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionCell> ABSOLUTE_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionCell> SUPREME_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionCell> COSMIC_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionCell> INFINITE_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionProvider> ABSOLUTE_INDUCTION_PROVIDER;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionProvider> SUPREME_INDUCTION_PROVIDER;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionProvider> COSMIC_INDUCTION_PROVIDER;
    public static final TileEntityTypeRegistryObject<ExtraTileEntityInductionProvider> INFINITE_INDUCTION_PROVIDER;

    private static void registerFactory(ExtraFactoryTier tier, FactoryType type, BlockEntityFactory<? extends TileEntityExtraFactory<?>> factoryConstructor) {
        BlockRegistryObject<BlockExtraFactoryMachine.BlockExtraFactory<?>, ItemBlockExtraFactory> block = ExtraBlocks.getExtraFactory(tier, type);
        TileEntityTypeRegistryObject tileRO = EXTRA_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> (TileEntityExtraFactory)((Object)((Object)factoryConstructor.create((Holder<Block>)block, pos, state)))).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        FACTORIES.put((Object)tier, (Object)type, (Object)tileRO);
    }

    private static TileEntityTypeRegistryObject<ExtraTileEntityBin> registerBin(BlockRegistryObject<ExtraBlockBin, ExtraItemBlockBin> block) {
        return EXTRA_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> new ExtraTileEntityBin((Holder<Block>)block, pos, state)).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
    }

    private static TileEntityTypeRegistryObject<ExtraTileEntityEnergyCube> registerEnergyCube(BlockRegistryObject<ExtraBlockEnergyCube, ExtraItemBlockEnergyCube> block) {
        return EXTRA_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> new ExtraTileEntityEnergyCube((Holder<Block>)block, pos, state)).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
    }

    private static TileEntityTypeRegistryObject<ExtraTileEntityFluidTank> registerFluidTank(BlockRegistryObject<ExtraBlockFluidTank, ExtraItemBlockFluidTank> block) {
        return EXTRA_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> new ExtraTileEntityFluidTank((Holder<Block>)block, pos, state)).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).withSimple(Capabilities.CONFIGURABLE).build();
    }

    private static TileEntityTypeRegistryObject<ExtraTileEntityChemicalTank> registerChemicalTank(BlockRegistryObject<?, ExtraItemBlockChemicalTank> block) {
        return EXTRA_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> new ExtraTileEntityChemicalTank((Holder<Block>)block, pos, state)).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
    }

    private static TileEntityTypeRegistryObject<TileEntityLargeCapRadioactiveWasteBarrel> registryWasteBarrel(BlockRegistryObject<?, ItemBlockLargeCapRadioactiveWasteBarrel> block) {
        return EXTRA_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> new TileEntityLargeCapRadioactiveWasteBarrel((Holder<Block>)block, pos, state)).serverTicker(TileEntityMekanism::tickServer).build();
    }

    private static TileEntityTypeRegistryObject<ExtraTileEntityUniversalCable> registerCable(BlockRegistryObject<?, ?> block) {
        TileEntityTypeDeferredRegister.BlockEntityTypeBuilder<ExtraTileEntityUniversalCable> builder = ExtraTileEntityTypes.transmitterBuilder(block, ExtraTileEntityUniversalCable::new);
        EnergyCompatUtils.addBlockCapabilities(builder);
        if (Mekanism.hooks.computerCompatEnabled()) {
            ComputerCapabilityHelper.addComputerCapabilities(builder, (BooleanSupplier)ConstantPredicates.ALWAYS_TRUE);
        }
        return builder.build();
    }

    private static TileEntityTypeRegistryObject<ExtraTileEntityMechanicalPipe> registerPipe(BlockRegistryObject<?, ?> block) {
        TileEntityTypeDeferredRegister.BlockEntityTypeBuilder builder = ExtraTileEntityTypes.transmitterBuilder(block, ExtraTileEntityMechanicalPipe::new).with(Capabilities.FLUID.block(), CapabilityTileEntity.FLUID_HANDLER_PROVIDER);
        if (Mekanism.hooks.computerCompatEnabled()) {
            ComputerCapabilityHelper.addComputerCapabilities((TileEntityTypeDeferredRegister.BlockEntityTypeBuilder)builder, (BooleanSupplier)ConstantPredicates.ALWAYS_TRUE);
        }
        return builder.build();
    }

    private static TileEntityTypeRegistryObject<ExtraTileEntityPressurizedTube> registerTube(BlockRegistryObject<?, ?> block) {
        TileEntityTypeDeferredRegister.BlockEntityTypeBuilder builder = ExtraTileEntityTypes.transmitterBuilder(block, ExtraTileEntityPressurizedTube::new).with(Capabilities.CHEMICAL.block(), CapabilityTileEntity.CHEMICAL_HANDLER_PROVIDER);
        if (Mekanism.hooks.computerCompatEnabled()) {
            ComputerCapabilityHelper.addComputerCapabilities((TileEntityTypeDeferredRegister.BlockEntityTypeBuilder)builder, (BooleanSupplier)ConstantPredicates.ALWAYS_TRUE);
        }
        return builder.build();
    }

    private static <BE extends ExtraTileEntityLogisticalTransporterBase> TileEntityTypeRegistryObject<BE> registerTransporter(BlockRegistryObject<?, ?> block, BlockEntityFactory<BE> factory) {
        return ExtraTileEntityTypes.transporterBuilder(block, factory).build();
    }

    private static <BE extends ExtraTileEntityLogisticalTransporterBase> TileEntityTypeDeferredRegister.BlockEntityTypeBuilder<BE> transporterBuilder(BlockRegistryObject<?, ?> block, BlockEntityFactory<BE> factory) {
        return ExtraTileEntityTypes.transmitterBuilder(block, factory).clientTicker(ExtraTileEntityLogisticalTransporterBase::tickClient).with(Capabilities.ITEM.block(), CapabilityTileEntity.ITEM_HANDLER_PROVIDER);
    }

    private static TileEntityTypeRegistryObject<ExtraTileEntityThermodynamicConductor> registerConductor(BlockRegistryObject<?, ?> block) {
        return ExtraTileEntityTypes.transmitterBuilder(block, ExtraTileEntityThermodynamicConductor::new).with(Capabilities.HEAT, CapabilityTileEntity.HEAT_HANDLER_PROVIDER).build();
    }

    private static <BE extends ExtraTileEntityTransmitter> TileEntityTypeDeferredRegister.BlockEntityTypeBuilder<BE> transmitterBuilder(BlockRegistryObject<?, ?> block, BlockEntityFactory<BE> factory) {
        return EXTRA_TILE_ENTITY_TYPES.builder(block, (pos, state) -> (ExtraTileEntityTransmitter)factory.create((Holder<Block>)block, pos, state)).serverTicker(ExtraTileEntityTransmitter::tickServer).withSimple(ExtraCapabilities.EXTRA_ALLOY_INTERACTION).with(Capabilities.CONFIGURABLE, ExtraTileEntityTransmitter.CONFIGURABLE_PROVIDER);
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityExtraFactory<?>> getAdvancedFactoryTile(ExtraFactoryTier tier, FactoryType type) {
        return (TileEntityTypeRegistryObject)FACTORIES.get((Object)tier, (Object)type);
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityExtraFactory<?>>[] getAdvancedFactoryTiles() {
        return FACTORIES.values().toArray(new TileEntityTypeRegistryObject[0]);
    }

    public static void register(IEventBus eventBus) {
        EXTRA_TILE_ENTITY_TYPES.register(eventBus);
    }

    static {
        for (ExtraFactoryTier tier : ExtraEnumUtils.EXTRA_FACTORY_TIERS) {
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.COMBINING, TileEntityCombiningExtraFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.COMPRESSING, TileEntityItemStackChemicalToItemStackExtraFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.CRUSHING, TileEntityItemStackToItemStackExtraFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.ENRICHING, TileEntityItemStackToItemStackExtraFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.INFUSING, TileEntityItemStackChemicalToItemStackExtraFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.INJECTING, TileEntityItemStackChemicalToItemStackExtraFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.PURIFYING, TileEntityItemStackChemicalToItemStackExtraFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.SAWING, TileEntitySawingExtraFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.SMELTING, TileEntityItemStackToItemStackExtraFactory::new);
        }
        ADVANCED_ELECTRIC_PUMP = EXTRA_TILE_ENTITY_TYPES.mekBuilder(ExtraBlocks.ADVANCED_ELECTRIC_PUMP, TileEntityAdvancedElectricPump::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).withSimple(Capabilities.CONFIGURABLE).build();
        ABSOLUTE_BIN = ExtraTileEntityTypes.registerBin(ExtraBlocks.ABSOLUTE_BIN);
        SUPREME_BIN = ExtraTileEntityTypes.registerBin(ExtraBlocks.SUPREME_BIN);
        COSMIC_BIN = ExtraTileEntityTypes.registerBin(ExtraBlocks.COSMIC_BIN);
        INFINITE_BIN = ExtraTileEntityTypes.registerBin(ExtraBlocks.INFINITE_BIN);
        ABSOLUTE_ENERGY_CUBE = ExtraTileEntityTypes.registerEnergyCube(ExtraBlocks.ABSOLUTE_ENERGY_CUBE);
        SUPREME_ENERGY_CUBE = ExtraTileEntityTypes.registerEnergyCube(ExtraBlocks.SUPREME_ENERGY_CUBE);
        COSMIC_ENERGY_CUBE = ExtraTileEntityTypes.registerEnergyCube(ExtraBlocks.COSMIC_ENERGY_CUBE);
        INFINITE_ENERGY_CUBE = ExtraTileEntityTypes.registerEnergyCube(ExtraBlocks.INFINITE_ENERGY_CUBE);
        ABSOLUTE_FLUID_TANK = ExtraTileEntityTypes.registerFluidTank(ExtraBlocks.ABSOLUTE_FLUID_TANK);
        SUPREME_FLUID_TANK = ExtraTileEntityTypes.registerFluidTank(ExtraBlocks.SUPREME_FLUID_TANK);
        COSMIC_FLUID_TANK = ExtraTileEntityTypes.registerFluidTank(ExtraBlocks.COSMIC_FLUID_TANK);
        INFINITE_FLUID_TANK = ExtraTileEntityTypes.registerFluidTank(ExtraBlocks.INFINITE_FLUID_TANK);
        ABSOLUTE_CHEMICAL_TANK = ExtraTileEntityTypes.registerChemicalTank(ExtraBlocks.ABSOLUTE_CHEMICAL_TANK);
        SUPREME_CHEMICAL_TANK = ExtraTileEntityTypes.registerChemicalTank(ExtraBlocks.SUPREME_CHEMICAL_TANK);
        COSMIC_CHEMICAL_TANK = ExtraTileEntityTypes.registerChemicalTank(ExtraBlocks.COSMIC_CHEMICAL_TANK);
        INFINITE_CHEMICAL_TANK = ExtraTileEntityTypes.registerChemicalTank(ExtraBlocks.INFINITE_CHEMICAL_TANK);
        ABSOLUTE_RADIOACTIVE_WASTE_BARREL = ExtraTileEntityTypes.registryWasteBarrel(ExtraBlocks.ABSOLUTE_RADIOACTIVE_WASTE_BARREL);
        SUPREME_RADIOACTIVE_WASTE_BARREL = ExtraTileEntityTypes.registryWasteBarrel(ExtraBlocks.SUPREME_RADIOACTIVE_WASTE_BARREL);
        COSMIC_RADIOACTIVE_WASTE_BARREL = ExtraTileEntityTypes.registryWasteBarrel(ExtraBlocks.COSMIC_RADIOACTIVE_WASTE_BARREL);
        INFINITE_RADIOACTIVE_WASTE_BARREL = ExtraTileEntityTypes.registryWasteBarrel(ExtraBlocks.INFINITE_RADIOACTIVE_WASTE_BARREL);
        ABSOLUTE_UNIVERSAL_CABLE = ExtraTileEntityTypes.registerCable(ExtraBlocks.ABSOLUTE_UNIVERSAL_CABLE);
        SUPREME_UNIVERSAL_CABLE = ExtraTileEntityTypes.registerCable(ExtraBlocks.SUPREME_UNIVERSAL_CABLE);
        COSMIC_UNIVERSAL_CABLE = ExtraTileEntityTypes.registerCable(ExtraBlocks.COSMIC_UNIVERSAL_CABLE);
        INFINITE_UNIVERSAL_CABLE = ExtraTileEntityTypes.registerCable(ExtraBlocks.INFINITE_UNIVERSAL_CABLE);
        ABSOLUTE_MECHANICAL_PIPE = ExtraTileEntityTypes.registerPipe(ExtraBlocks.ABSOLUTE_MECHANICAL_PIPE);
        SUPREME_MECHANICAL_PIPE = ExtraTileEntityTypes.registerPipe(ExtraBlocks.SUPREME_MECHANICAL_PIPE);
        COSMIC_MECHANICAL_PIPE = ExtraTileEntityTypes.registerPipe(ExtraBlocks.COSMIC_MECHANICAL_PIPE);
        INFINITE_MECHANICAL_PIPE = ExtraTileEntityTypes.registerPipe(ExtraBlocks.INFINITE_MECHANICAL_PIPE);
        ABSOLUTE_PRESSURIZED_TUBE = ExtraTileEntityTypes.registerTube(ExtraBlocks.ABSOLUTE_PRESSURIZED_TUBE);
        SUPREME_PRESSURIZED_TUBE = ExtraTileEntityTypes.registerTube(ExtraBlocks.SUPREME_PRESSURIZED_TUBE);
        COSMIC_PRESSURIZED_TUBE = ExtraTileEntityTypes.registerTube(ExtraBlocks.COSMIC_PRESSURIZED_TUBE);
        INFINITE_PRESSURIZED_TUBE = ExtraTileEntityTypes.registerTube(ExtraBlocks.INFINITE_PRESSURIZED_TUBE);
        ABSOLUTE_LOGISTICAL_TRANSPORTER = ExtraTileEntityTypes.registerTransporter(ExtraBlocks.ABSOLUTE_LOGISTICAL_TRANSPORTER, ExtraTileEntityLogisticalTransporter::new);
        SUPREME_LOGISTICAL_TRANSPORTER = ExtraTileEntityTypes.registerTransporter(ExtraBlocks.SUPREME_LOGISTICAL_TRANSPORTER, ExtraTileEntityLogisticalTransporter::new);
        COSMIC_LOGISTICAL_TRANSPORTER = ExtraTileEntityTypes.registerTransporter(ExtraBlocks.COSMIC_LOGISTICAL_TRANSPORTER, ExtraTileEntityLogisticalTransporter::new);
        INFINITE_LOGISTICAL_TRANSPORTER = ExtraTileEntityTypes.registerTransporter(ExtraBlocks.INFINITE_LOGISTICAL_TRANSPORTER, ExtraTileEntityLogisticalTransporter::new);
        ABSOLUTE_THERMODYNAMIC_CONDUCTOR = ExtraTileEntityTypes.registerConductor(ExtraBlocks.ABSOLUTE_THERMODYNAMIC_CONDUCTOR);
        SUPREME_THERMODYNAMIC_CONDUCTOR = ExtraTileEntityTypes.registerConductor(ExtraBlocks.SUPREME_THERMODYNAMIC_CONDUCTOR);
        COSMIC_THERMODYNAMIC_CONDUCTOR = ExtraTileEntityTypes.registerConductor(ExtraBlocks.COSMIC_THERMODYNAMIC_CONDUCTOR);
        INFINITE_THERMODYNAMIC_CONDUCTOR = ExtraTileEntityTypes.registerConductor(ExtraBlocks.INFINITE_THERMODYNAMIC_CONDUCTOR);
        REINFORCED_INDUCTION_CASING = EXTRA_TILE_ENTITY_TYPES.mekBuilder(ExtraBlocks.REINFORCED_INDUCTION_CASING, TileEntityReinforcedInductionCasing::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).without(new BlockCapability[]{Capabilities.ITEM.block()}).build();
        REINFORCED_INDUCTION_PORT = EXTRA_TILE_ENTITY_TYPES.mekBuilder(ExtraBlocks.REINFORCED_INDUCTION_PORT, TileEntityReinforcedInductionPort::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
        ABSOLUTE_INDUCTION_CELL = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.ABSOLUTE_INDUCTION_CELL, (pos, state) -> new ExtraTileEntityInductionCell((Holder<Block>)ExtraBlocks.ABSOLUTE_INDUCTION_CELL, pos, state)).build();
        SUPREME_INDUCTION_CELL = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.SUPREME_INDUCTION_CELL, (pos, state) -> new ExtraTileEntityInductionCell((Holder<Block>)ExtraBlocks.SUPREME_INDUCTION_CELL, pos, state)).build();
        COSMIC_INDUCTION_CELL = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.COSMIC_INDUCTION_CELL, (pos, state) -> new ExtraTileEntityInductionCell((Holder<Block>)ExtraBlocks.COSMIC_INDUCTION_CELL, pos, state)).build();
        INFINITE_INDUCTION_CELL = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.INFINITE_INDUCTION_CELL, (pos, state) -> new ExtraTileEntityInductionCell((Holder<Block>)ExtraBlocks.INFINITE_INDUCTION_CELL, pos, state)).build();
        ABSOLUTE_INDUCTION_PROVIDER = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.ABSOLUTE_INDUCTION_PROVIDER, (pos, state) -> new ExtraTileEntityInductionProvider((Holder<Block>)ExtraBlocks.ABSOLUTE_INDUCTION_PROVIDER, pos, state)).build();
        SUPREME_INDUCTION_PROVIDER = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.SUPREME_INDUCTION_PROVIDER, (pos, state) -> new ExtraTileEntityInductionProvider((Holder<Block>)ExtraBlocks.SUPREME_INDUCTION_PROVIDER, pos, state)).build();
        COSMIC_INDUCTION_PROVIDER = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.COSMIC_INDUCTION_PROVIDER, (pos, state) -> new ExtraTileEntityInductionProvider((Holder<Block>)ExtraBlocks.COSMIC_INDUCTION_PROVIDER, pos, state)).build();
        INFINITE_INDUCTION_PROVIDER = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.INFINITE_INDUCTION_PROVIDER, (pos, state) -> new ExtraTileEntityInductionProvider((Holder<Block>)ExtraBlocks.INFINITE_INDUCTION_PROVIDER, pos, state)).build();
    }

    @FunctionalInterface
    private static interface BlockEntityFactory<BE extends BlockEntity> {
        public BE create(Holder<Block> var1, BlockPos var2, BlockState var3);
    }
}

