/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.tier;

import com.jerry.mekextras.api.tier.AdvancedTier;
import com.jerry.mekextras.api.tier.IAdvancedTier;
import java.util.Locale;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.config.value.CachedLongValue;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public enum ECTier implements IAdvancedTier,
StringRepresentable
{
    ABSOLUTE(AdvancedTier.ABSOLUTE, 1024000000L, 1024000L),
    SUPREME(AdvancedTier.SUPREME, 4096000000L, 4096000L),
    COSMIC(AdvancedTier.COSMIC, 16384000000L, 0xFA0000L),
    INFINITE(AdvancedTier.INFINITE, 65536000000L, 65536000L);

    private final long advanceMaxEnergy;
    private final long advanceOutput;
    private final AdvancedTier advancedTier;
    @Nullable
    private CachedLongValue storageReference;
    @Nullable
    private CachedLongValue outputReference;

    private ECTier(AdvancedTier tier, long max, long out) {
        this.advanceMaxEnergy = max;
        this.advanceOutput = out;
        this.advancedTier = tier;
    }

    @Override
    public AdvancedTier getAdvanceTier() {
        return this.advancedTier;
    }

    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public long getMaxEnergy() {
        return this.storageReference == null ? this.getAdvanceMaxEnergy() : this.storageReference.getOrDefault();
    }

    public long getOutput() {
        return this.outputReference == null ? this.getAdvanceOutput() : this.outputReference.getOrDefault();
    }

    public long getAdvanceMaxEnergy() {
        return this.advanceMaxEnergy;
    }

    public long getAdvanceOutput() {
        return this.advanceOutput;
    }

    public void setConfigReference(CachedLongValue storageReference, CachedLongValue outputReference) {
        this.storageReference = storageReference;
        this.outputReference = outputReference;
    }
}

