/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.tile.factory;

import com.jerry.mekextras.common.tile.factory.TileEntityItemToItemExtraFactory;
import fr.iglee42.evolvedmekanism.interfaces.EMInputRecipeCache;
import fr.iglee42.evolvedmekanism.interfaces.IGetEnergySlot;
import fr.iglee42.evolvedmekanism.interfaces.ThreeInputCachedRecipe;
import fr.iglee42.evolvedmekanism.interfaces.TripleItemRecipeLookupHandler;
import fr.iglee42.evolvedmekanism.recipes.AlloyerRecipe;
import fr.iglee42.evolvedmekanism.registries.EMRecipeType;
import fr.iglee42.evolvedmekanism.tiles.LimitedInputInventorySlot;
import fr.iglee42.evolvedmekanism.tiles.upgrade.AlloyerUpgradeData;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityAlloyingExtraFactory
extends TileEntityItemToItemExtraFactory<AlloyerRecipe>
implements TripleItemRecipeLookupHandler<AlloyerRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    LimitedInputInventorySlot extraSlot;
    LimitedInputInventorySlot secondExtraSlot;
    private final IInputHandler<@NotNull ItemStack> extraInputHandler;
    private final IInputHandler<@NotNull ItemStack> secondExtraInputHandler;

    public TileEntityAlloyingExtraFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.EXTRA, (ISlotInfo)new InventorySlotInfo(true, true, List.of(this.extraSlot, this.secondExtraSlot)));
        }
        this.extraInputHandler = InputHelper.getInputHandler((IInventorySlot)this.extraSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
        this.secondExtraInputHandler = InputHelper.getInputHandler((IInventorySlot)this.secondExtraSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<AlloyerRecipe> cached, @NotNull ItemStack stack) {
        if (cached != null) {
            AlloyerRecipe cachedRecipe = (AlloyerRecipe)cached.getRecipe();
            return cachedRecipe.getMainInput().testType(stack) && (this.extraSlot.isEmpty() || cachedRecipe.getExtraInput().testType(this.extraSlot.getStack()));
        }
        return false;
    }

    @Override
    @Nullable
    protected AlloyerRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        ItemStack extra = this.extraSlot.getStack();
        ItemStack secondExtra = this.secondExtraSlot.getStack();
        ItemStack output = outputSlot.getStack();
        return (AlloyerRecipe)((EMInputRecipeCache.IFindRecipes)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.level, (Object)fallbackInput, (Object)extra, (Object)secondExtra, recipe -> InventoryUtils.areItemsStackable((ItemStack)recipe.getOutput(fallbackInput, extra, secondExtra), (ItemStack)output));
    }

    @Override
    protected int getNeededInput(AlloyerRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getMainInput().getNeededAmount(inputStack));
    }

    @Override
    public boolean isItemValidForSlot(@NotNull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    @Override
    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    @NotNull
    public IMekanismRecipeTypeProvider<?, AlloyerRecipe, EMInputRecipeCache.TripleItem<AlloyerRecipe>> getRecipeType() {
        return EMRecipeType.ALLOYING;
    }

    @Nullable
    public AlloyerRecipe getRecipe(int cacheIndex) {
        return (AlloyerRecipe)this.findFirstRecipe(this.inputHandlers[cacheIndex], this.extraInputHandler, this.secondExtraInputHandler);
    }

    @NotNull
    public CachedRecipe<AlloyerRecipe> createNewCachedRecipe(@NotNull AlloyerRecipe recipe, int cacheIndex) {
        return ThreeInputCachedRecipe.alloyer((AlloyerRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors[cacheIndex], (IInputHandler)this.inputHandlers[cacheIndex], this.extraInputHandler, this.secondExtraInputHandler, (IOutputHandler)this.outputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> ((TileEntityAlloyingExtraFactory)this).canFunction()).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((MachineEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityAlloyingExtraFactory)this).markForSave()).setBaselineMaxOperations(this::getOperationsPerTick).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof AlloyerUpgradeData) {
            AlloyerUpgradeData data = (AlloyerUpgradeData)upgradeData;
            super.parseUpgradeData(provider, upgradeData);
            this.extraSlot.deserializeNBT(provider, data.extraSlot.serializeNBT(provider));
            this.secondExtraSlot.deserializeNBT(provider, data.secondaryExtraSlot.serializeNBT(provider));
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @NotNull
    public AlloyerUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new AlloyerUpgradeData(provider, this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, ((IGetEnergySlot)this).getEnergySlot(), this.extraSlot, this.secondExtraSlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }
}

