/*
 * Decompiled with CFR 0.152.
 */
package velvet.mysticalextendedtier.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.lib.Tooltips;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import velvet.mysticalextendedtier.lib.ModTooltips;
import velvet.mysticalextendedtier.util.EssenceAppleTier;

public class EssenceAppleItem
extends BaseItem {
    private static final FoodProperties.Builder food = new FoodProperties.Builder().alwaysEdible();
    private final EssenceAppleTier tier;

    public EssenceAppleItem(EssenceAppleTier tier) {
        super(p -> p.food(food.nutrition(tier.getHunger()).saturationModifier(tier.getSaturation()).build()));
        this.tier = tier;
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.isClientSide()) {
            this.tier.onFoodEaten(entity);
        }
        return entity.eat(level, stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)ModTooltips.GIVES_BUFFS.build());
            tooltip.addAll(this.tier.getTooltip());
        } else {
            tooltip.add((Component)Tooltips.HOLD_SHIFT_FOR_INFO.build());
        }
    }
}

