/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.EnumSet;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.item.ClassifyFilterItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncClassifyFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;

public class ClassifyFilterScreen
extends AbstractPneumaticCraftScreen {
    private final InteractionHand handIn;
    private final EnumSet<ClassifyFilterItem.FilterCondition> conditions = EnumSet.noneOf(ClassifyFilterItem.FilterCondition.class);
    private boolean matchAll;
    private WidgetButtonExtended matchButton;

    private ClassifyFilterScreen(Component title, InteractionHand handIn) {
        super(title);
        this.handIn = handIn;
        this.xSize = 256;
        this.ySize = 202;
        ClassifyFilterItem.FilterSettings settings = ClassifyFilterItem.FilterSettings.fromStack(ClientUtils.getClientPlayer().getItemInHand(handIn));
        this.conditions.addAll(settings.filterConditions());
        this.matchAll = settings.matchAll();
    }

    public static void openGui(Component title, InteractionHand handIn) {
        Minecraft.getInstance().setScreen((Screen)new ClassifyFilterScreen(title, handIn));
    }

    @Override
    public void init() {
        super.init();
        int x = this.guiLeft + 55;
        int y = this.guiTop + 20;
        for (ClassifyFilterItem.FilterCondition cond : ClassifyFilterItem.FilterCondition.values()) {
            WidgetCheckBox cb = (WidgetCheckBox)this.addRenderableWidget((GuiEventListener)new WidgetCheckBox(x + 20, y + 5, 20, (Component)Component.empty(), b -> this.toggleCondition(cond)).setChecked(this.conditions.contains(cond)));
            cb.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate(cond.getTranslationKey(), new Object[0])));
            WidgetButtonExtended btn = new WidgetButtonExtended(x, y, 20, 20, "", b -> {
                this.toggleCondition(cond);
                cb.setChecked(this.conditions.contains(cond));
            }).setRenderStacks(cond.getIcon()).setVisible(false);
            btn.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate(cond.getTranslationKey(), new Object[0])));
            this.addRenderableWidget((GuiEventListener)btn);
            if ((y += 20) <= this.guiTop + 140) continue;
            x += 100;
            y = this.guiTop + 20;
        }
        MutableComponent txtAny = ClassifyFilterItem.xlateMatch(false);
        MutableComponent txtAll = ClassifyFilterItem.xlateMatch(true);
        int w = Math.max(this.font.width((FormattedText)txtAll), this.font.width((FormattedText)txtAny)) + 20;
        this.matchButton = (WidgetButtonExtended)this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(this.guiLeft + (this.xSize - w) / 2, this.guiTop + 170, w, 20, (Component)(this.matchAll ? txtAll : txtAny), b -> this.toggleMatchAll()));
    }

    private void toggleMatchAll() {
        this.matchAll = !this.matchAll;
        this.matchButton.setMessage((Component)ClassifyFilterItem.xlateMatch(this.matchAll));
        NetworkHandler.sendToServer(new PacketSyncClassifyFilter(this.matchAll, this.conditions, this.handIn));
    }

    private void toggleCondition(ClassifyFilterItem.FilterCondition cond) {
        if (this.conditions.contains(cond)) {
            this.conditions.remove(cond);
        } else {
            this.conditions.add(cond);
        }
        NetworkHandler.sendToServer(new PacketSyncClassifyFilter(this.matchAll, this.conditions, this.handIn));
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        GuiUtils.drawNineSliced(graphics, Textures.GUI_BLANK_256, this.guiLeft, this.guiTop, 0, this.xSize, this.ySize, 256, 256, 4);
    }

    @Override
    protected void drawForeground(GuiGraphics graphics, int x, int y, float partialTicks) {
        super.drawForeground(graphics, x, y, partialTicks);
        graphics.drawString(this.font, this.title, this.guiLeft + (this.xSize - this.font.width((FormattedText)this.title)) / 2, this.guiTop + 8, 0x404040, false);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return null;
    }
}

