/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.programmer;

import java.util.Objects;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.InventorySearcherScreen;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.gui.programmer.ProgWidgetAreaShowScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetRadioButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCoordinate;
import me.desht.pneumaticcraft.common.item.GPSToolItem;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ProgWidgetCoordinateScreen
extends ProgWidgetAreaShowScreen<ProgWidgetCoordinate> {
    private InventorySearcherScreen invSearchGui;
    private WidgetTextFieldNumber[] coordFields;
    private WidgetComboBox variableField;
    private WidgetButtonExtended gpsButton;

    public ProgWidgetCoordinateScreen(ProgWidgetCoordinate widget, ProgrammerScreen guiProgrammer) {
        super(widget, guiProgrammer);
    }

    @Override
    public void init() {
        super.init();
        if (this.invSearchGui != null) {
            ((ProgWidgetCoordinate)this.progWidget).setCoordinate(this.invSearchGui.getBlockPos());
            this.invSearchGui = null;
        }
        WidgetRadioButton.Builder.create().addRadioButton(new WidgetRadioButton(this.guiLeft + 7, this.guiTop + 51, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinate.constant", new Object[0]), b -> this.setUsingVariable(false)), !((ProgWidgetCoordinate)this.progWidget).isUsingVariable()).addRadioButton(new WidgetRadioButton(this.guiLeft + 7, this.guiTop + 100, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinate.variable", new Object[0]), b -> this.setUsingVariable(true)), ((ProgWidgetCoordinate)this.progWidget).isUsingVariable()).build(x$0 -> {
            WidgetRadioButton cfr_ignored_0 = (WidgetRadioButton)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.gpsButton = new WidgetButtonExtended(this.guiLeft + 100, this.guiTop + 20, 20, 20, (Component)Component.empty(), b -> this.openGPSSearcher());
        this.gpsButton.setRenderStacks(new ItemStack((ItemLike)ModItems.GPS_TOOL.get()));
        this.gpsButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinate.selectFromGPS", new Object[0]));
        this.gpsButton.active = !((ProgWidgetCoordinate)this.progWidget).isUsingVariable();
        this.addRenderableWidget((GuiEventListener)this.gpsButton);
        this.coordFields = new WidgetTextFieldNumber[3];
        for (int i = 0; i < 3; ++i) {
            Objects.requireNonNull(this.font);
            this.coordFields[i] = new WidgetTextFieldNumber(this.font, this.guiLeft + 100, this.guiTop + 50 + 13 * i, 40, 9 + 1);
            this.addRenderableWidget((GuiEventListener)this.coordFields[i]);
            this.coordFields[i].setEditable(this.gpsButton.active);
        }
        BlockPos coord = ((ProgWidgetCoordinate)this.progWidget).getRawCoordinate().orElse(BlockPos.ZERO);
        this.coordFields[0].setValue(coord.getX());
        this.coordFields[1].setValue(coord.getY());
        this.coordFields[2].setValue(coord.getZ());
        Objects.requireNonNull(this.font);
        this.variableField = new WidgetComboBox(this.font, this.guiLeft + 90, this.guiTop + 112, 80, 9 + 1);
        this.variableField.setElements(((ProgrammerBlockEntity)this.guiProgrammer.te).getAllVariables());
        this.variableField.setMaxLength(64);
        this.addRenderableWidget((GuiEventListener)this.variableField);
        this.variableField.setValue(((ProgWidgetCoordinate)this.progWidget).getVariable());
        this.variableField.setEditable(((ProgWidgetCoordinate)this.progWidget).isUsingVariable());
    }

    private void setUsingVariable(boolean usingVariable) {
        ((ProgWidgetCoordinate)this.progWidget).setUsingVariable(usingVariable);
        this.gpsButton.active = !usingVariable;
        for (WidgetTextFieldNumber textField : this.coordFields) {
            textField.setEditable(!usingVariable);
        }
        this.variableField.setEditable(usingVariable);
    }

    private void openGPSSearcher() {
        ClientUtils.openContainerGui(ModMenuTypes.INVENTORY_SEARCHER.get(), (Component)Component.literal((String)"Inventory Searcher (GPS)"));
        if (this.minecraft.screen instanceof InventorySearcherScreen) {
            this.invSearchGui = (InventorySearcherScreen)this.minecraft.screen;
            this.invSearchGui.setStackPredicate(itemStack -> itemStack.getItem() instanceof IPositionProvider);
            BlockPos coord = ((ProgWidgetCoordinate)this.progWidget).getRawCoordinate().orElse(BlockPos.ZERO);
            ItemStack gpsStack = new ItemStack((ItemLike)ModItems.GPS_TOOL.get());
            GPSToolItem.setGPSLocation(ClientUtils.getClientPlayer().getUUID(), gpsStack, coord);
            this.invSearchGui.setSearchStack(GPSToolItem.getGPSLocation(gpsStack).isPresent() ? gpsStack : ItemStack.EMPTY);
        }
    }

    @Override
    public void removed() {
        ((ProgWidgetCoordinate)this.progWidget).setCoordinate(new BlockPos(this.coordFields[0].getIntValue(), this.coordFields[1].getIntValue(), this.coordFields[2].getIntValue()));
        ((ProgWidgetCoordinate)this.progWidget).setVariable(this.variableField.getValue());
        super.removed();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawString(this.font, "x:", this.guiLeft + 90, this.guiTop + 51, -12566464, false);
        graphics.drawString(this.font, "y:", this.guiLeft + 90, this.guiTop + 64, -12566464, false);
        graphics.drawString(this.font, "z:", this.guiLeft + 90, this.guiTop + 77, -12566464, false);
        graphics.drawString(this.font, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinate.variableName", new Object[0]), this.guiLeft + 90, this.guiTop + 100, -12566432, false);
    }
}

