/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.processing.PressureChamberInterfaceBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;

public class PressureChamberInterfaceRenderer
extends AbstractBlockEntityModelRenderer<PressureChamberInterfaceBlockEntity> {
    private final ModelPart inputLeft;
    private final ModelPart inputRight;
    private final ModelPart inputBottom;
    private final ModelPart inputTop;
    private final ModelPart outputLeft;
    private final ModelPart outputRight;
    private final ModelPart outputBottom;
    private final ModelPart outputTop;
    private static final String INPUTLEFT = "inputLeft";
    private static final String INPUTRIGHT = "inputRight";
    private static final String INPUTBOTTOM = "inputBottom";
    private static final String INPUTTOP = "inputTop";
    private static final String OUTPUTLEFT = "outputLeft";
    private static final String OUTPUTRIGHT = "outputRight";
    private static final String OUTPUTBOTTOM = "outputBottom";
    private static final String OUTPUTTOP = "outputTop";

    public PressureChamberInterfaceRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.bakeLayer(PNCModelLayers.PRESSURE_CHAMBER_INTERFACE);
        this.inputLeft = root.getChild(INPUTLEFT);
        this.inputRight = root.getChild(INPUTRIGHT);
        this.inputBottom = root.getChild(INPUTBOTTOM);
        this.inputTop = root.getChild(INPUTTOP);
        this.outputLeft = root.getChild(OUTPUTLEFT);
        this.outputRight = root.getChild(OUTPUTRIGHT);
        this.outputBottom = root.getChild(OUTPUTBOTTOM);
        this.outputTop = root.getChild(OUTPUTTOP);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(INPUTLEFT, CubeListBuilder.create().texOffs(0, 0).addBox("inputLeft_0", -4.0f, -12.0f, -6.0f, 4.0f, 8.0f, 1.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(INPUTRIGHT, CubeListBuilder.create().texOffs(10, 0).addBox("inputRight_0", 0.0f, -12.0f, -6.0f, 4.0f, 8.0f, 1.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(INPUTBOTTOM, CubeListBuilder.create().texOffs(0, 9).addBox("inputBottom_0", -4.0f, -8.0f, -5.0f, 8.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(INPUTTOP, CubeListBuilder.create().texOffs(0, 14).addBox("inputTop_0", -4.0f, -12.0f, -5.0f, 8.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(OUTPUTLEFT, CubeListBuilder.create().texOffs(0, 19).addBox("outputLeft_0", -4.0f, -12.0f, 5.0f, 4.0f, 8.0f, 1.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(OUTPUTRIGHT, CubeListBuilder.create().texOffs(10, 19).addBox("outputRight_0", 0.0f, -12.0f, 5.0f, 4.0f, 8.0f, 1.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(OUTPUTBOTTOM, CubeListBuilder.create().texOffs(0, 9).addBox("outputBottom_0", -4.0f, -8.0f, 4.0f, 8.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(OUTPUTTOP, CubeListBuilder.create().texOffs(0, 14).addBox("outputTop_0", -4.0f, -12.0f, 4.0f, 8.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    @Override
    public void renderModel(PressureChamberInterfaceBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)Textures.MODEL_PRESSURE_CHAMBER_INTERFACE));
        RenderUtils.rotateMatrixForDirection(matrixStackIn, te.getRotation());
        float inputProgress = Mth.lerp((float)partialTicks, (float)te.oldInputProgress, (float)te.inputProgress) / 40.0f;
        float outputProgress = Mth.lerp((float)partialTicks, (float)te.oldOutputProgress, (float)te.outputProgress) / 40.0f;
        if (inputProgress <= 1.0f) {
            matrixStackIn.pushPose();
            matrixStackIn.translate((double)((1.0f - (float)Math.cos((double)inputProgress * Math.PI)) * 0.122f) + 0.25, 0.0, 0.0);
            this.inputLeft.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            matrixStackIn.translate((double)((-1.0f + (float)Math.cos((double)inputProgress * Math.PI)) * 0.122f) - 0.25, 0.0, 0.0);
            this.inputRight.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0f, (1.0f - (float)Math.cos((double)inputProgress * Math.PI)) * 0.122f, 0.0f);
            this.inputBottom.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0f, (-1.0f + (float)Math.cos((double)inputProgress * Math.PI)) * 0.122f, 0.0f);
            this.inputTop.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
        }
        if (outputProgress < 1.0f) {
            matrixStackIn.pushPose();
            matrixStackIn.translate((double)((1.0f - (float)Math.cos((double)outputProgress * Math.PI)) * 0.122f) + 0.25, 0.0, 0.0);
            this.outputLeft.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            matrixStackIn.translate((double)((-1.0f + (float)Math.cos((double)outputProgress * Math.PI)) * 0.122f) - 0.25, 0.0, 0.0);
            this.outputRight.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0f, (1.0f - (float)Math.cos((double)outputProgress * Math.PI)) * 0.122f, 0.0f);
            this.outputBottom.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0f, (-1.0f + (float)Math.cos((double)outputProgress * Math.PI)) * 0.122f, 0.0f);
            this.outputTop.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
        }
    }

    @Override
    protected void renderExtras(PressureChamberInterfaceBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (!te.getStackInInterface().isEmpty()) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.5, 0.5);
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            BakedModel bakedModel = itemRenderer.getModel(te.getStackInInterface(), te.getLevel(), null, 0);
            itemRenderer.render(te.getStackInInterface(), ItemDisplayContext.GROUND, true, matrixStack, buffer, combinedLightIn, combinedOverlayIn, bakedModel);
            matrixStack.popPose();
        }
    }
}

