/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity.drone;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.entity.drone.ModelDrone;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.entity.drone.AbstractDroneEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;

public class DroneDigLaserLayer
extends RenderLayer<AbstractDroneEntity, ModelDrone> {
    private static final float LASER_SIZE = 0.4f;

    DroneDigLaserLayer(RenderLayerParent<AbstractDroneEntity, ModelDrone> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, AbstractDroneEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        BlockPos diggingPos = entityIn.getDugBlock();
        if (diggingPos != null) {
            matrixStackIn.pushPose();
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
            matrixStackIn.translate(0.0f, -1.0f, 0.0f);
            BlockState state = entityIn.getCommandSenderWorld().getBlockState(diggingPos);
            VoxelShape shape = state.getShape((BlockGetter)entityIn.getCommandSenderWorld(), diggingPos);
            if (shape.isEmpty()) {
                this.renderLaser(matrixStackIn, bufferIn, partialTicks, entityIn, 0.0, -entityIn.getLaserOffsetY(), 0.0, (double)diggingPos.getX() + 0.5 - entityIn.getX(), (double)diggingPos.getY() + 0.45 - entityIn.getY(), (double)diggingPos.getZ() + 0.5 - entityIn.getZ());
            } else {
                Vec3 vec = shape.bounds().getCenter().add(Vec3.atLowerCornerOf((Vec3i)diggingPos));
                this.renderLaser(matrixStackIn, bufferIn, partialTicks, entityIn, 0.0, -entityIn.getLaserOffsetY(), 0.0, vec.x() - entityIn.getX(), vec.y() - entityIn.getY(), vec.z() - entityIn.getZ());
            }
            matrixStackIn.popPose();
        }
    }

    private void renderLaser(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks, AbstractDroneEntity drone, double x1, double y1, double z1, double x2, double y2, double z2) {
        float laserLength = (float)PneumaticCraftUtils.distBetween(x1, y1, z1, x2, y2, z2);
        matrixStack.pushPose();
        matrixStack.translate(x1, y1, z1);
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        float f3 = Mth.sqrt((float)((float)(dx * dx + dz * dz)));
        double rotYawRad = Math.atan2(dx, dz);
        double rotPitchRad = 1.5707963267948966 - Math.atan2(dy, f3);
        matrixStack.mulPose(Axis.YP.rotation((float)rotYawRad));
        matrixStack.mulPose(Axis.XP.rotation((float)rotPitchRad));
        matrixStack.scale(0.4f, 0.4f, 0.4f);
        matrixStack.translate(0.0, 0.6, 0.0);
        matrixStack.mulPose(Axis.YP.rotationDegrees((float)drone.tickCount + partialTicks));
        matrixStack.pushPose();
        matrixStack.scale(1.0f, laserLength / 0.4f * 2.0f, 1.0f);
        int[] cols = RenderUtils.decomposeColor(drone.getLaserColor());
        Matrix4f posMat = matrixStack.last().pose();
        VertexConsumer builder = buffer.getBuffer(ModRenderTypes.getTextureRenderColored(Textures.RENDER_LASER));
        this.renderQuad(posMat, builder, cols);
        builder = buffer.getBuffer(ModRenderTypes.getTextureRenderColored(Textures.RENDER_LASER_OVERLAY));
        this.renderQuad(posMat, builder, cols);
        matrixStack.popPose();
        matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        posMat = matrixStack.last().pose();
        builder = buffer.getBuffer(ModRenderTypes.getTextureRenderColored(Textures.RENDER_LASER_START));
        this.renderQuad(posMat, builder, cols);
        builder = buffer.getBuffer(ModRenderTypes.getTextureRenderColored(Textures.RENDER_LASER_START_OVERLAY));
        this.renderQuad(posMat, builder, cols);
        matrixStack.popPose();
    }

    private void renderQuad(Matrix4f posMat, VertexConsumer builder, int[] cols) {
        builder.addVertex(posMat, -0.5f, 0.0f, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]).setUv(0.0f, 0.0f).setLight(0xF000F0);
        builder.addVertex(posMat, -0.5f, 1.0f, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]).setUv(0.0f, 1.0f).setLight(0xF000F0);
        builder.addVertex(posMat, 0.5f, 1.0f, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]).setUv(1.0f, 1.0f).setLight(0xF000F0);
        builder.addVertex(posMat, 0.5f, 0.0f, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]).setUv(1.0f, 0.0f).setLight(0xF000F0);
    }
}

