/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.minigun.MinigunItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

public class MinigunOverlay
implements LayeredDraw.Layer {
    private static final float MINIGUN_TEXT_SIZE = 0.55f;

    public void render(GuiGraphics graphics, DeltaTracker partialTicks) {
        MinigunItem itemMinigun;
        LocalPlayer player;
        int height;
        int width;
        Minecraft mc;
        block5: {
            block4: {
                Item item;
                mc = Minecraft.getInstance();
                width = graphics.guiWidth();
                height = graphics.guiHeight();
                player = mc.player;
                if (player == null || !((item = player.getMainHandItem().getItem()) instanceof MinigunItem)) break block4;
                itemMinigun = (MinigunItem)item;
                if (Minecraft.getInstance().options.getCameraType().isFirstPerson()) break block5;
            }
            return;
        }
        ItemStack heldStack = player.getMainHandItem();
        Minigun minigun = itemMinigun.getMinigun(heldStack, (Player)player);
        ItemStack ammo = minigun.getAmmoStack();
        if (!ammo.isEmpty()) {
            graphics.renderItem(ammo, width / 2 + 16, height / 2 - 7);
            int remaining = ammo.getMaxDamage() - ammo.getDamageValue();
            graphics.pose().pushPose();
            graphics.pose().translate((float)width / 2.0f + 32.0f, (float)height / 2.0f - 1.0f, 0.0f);
            graphics.pose().scale(0.55f, 0.55f, 1.0f);
            String text = remaining + "/" + ammo.getMaxDamage();
            graphics.drawString(mc.font, text, 1, 0, 0, false);
            graphics.drawString(mc.font, text, -1, 0, 0, false);
            graphics.drawString(mc.font, text, 0, 1, 0, false);
            graphics.drawString(mc.font, text, 0, -1, 0, false);
            graphics.drawString(mc.font, text, 0, 0, minigun.getAmmoColor(), false);
            graphics.pose().popPose();
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)0.2f, (float)0.7f, (float)0.2f, (float)0.75f);
        graphics.blit(Textures.MINIGUN_CROSSHAIR, width / 2 - 7, height / 2 - 7, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT})
    public static class Listener {
        @SubscribeEvent
        public static void crosshairsEvent(RenderGuiLayerEvent.Pre event) {
            boolean firstPerson = Minecraft.getInstance().options.getCameraType().isFirstPerson();
            if (event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR) && ClientUtils.getClientPlayer().getMainHandItem().getItem() instanceof MinigunItem && firstPerson) {
                event.setCanceled(true);
            }
        }
    }
}

