/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.api.block.PNCBlockStateProperties;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.compressor.PneumaticDynamoBlockEntity;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PneumaticDynamoBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    private static final VoxelShape SHAPE_UP = VoxelShapeUtils.or(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.box((double)0.0, (double)10.0, (double)0.0, (double)1.0, (double)11.0, (double)1.0), Block.box((double)15.0, (double)10.0, (double)0.0, (double)16.0, (double)11.0, (double)1.0), Block.box((double)15.0, (double)10.0, (double)15.0, (double)16.0, (double)11.0, (double)16.0), Block.box((double)0.0, (double)10.0, (double)15.0, (double)1.0, (double)11.0, (double)16.0), Block.box((double)0.0, (double)11.0, (double)0.0, (double)1.0, (double)12.0, (double)16.0), Block.box((double)15.0, (double)11.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)1.0, (double)11.0, (double)0.0, (double)15.0, (double)12.0, (double)1.0), Block.box((double)1.0, (double)11.0, (double)15.0, (double)15.0, (double)12.0, (double)16.0));
    private static final VoxelShape SHAPE_NORTH = VoxelShapeUtils.rotateX(SHAPE_UP, 270);
    private static final VoxelShape SHAPE_DOWN = VoxelShapeUtils.rotateX(SHAPE_NORTH, 270);
    private static final VoxelShape SHAPE_SOUTH = VoxelShapeUtils.rotateY(SHAPE_NORTH, 180);
    private static final VoxelShape SHAPE_EAST = VoxelShapeUtils.rotateY(SHAPE_NORTH, 90);
    private static final VoxelShape SHAPE_WEST = VoxelShapeUtils.rotateY(SHAPE_NORTH, 270);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_DOWN, SHAPE_UP, SHAPE_NORTH, SHAPE_SOUTH, SHAPE_WEST, SHAPE_EAST};

    public PneumaticDynamoBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)PNCBlockStateProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PNCBlockStateProperties.ACTIVE});
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    @Override
    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        return state == null ? null : (BlockState)state.setValue((Property)this.directionProperty(), (Comparable)ctx.getClickedFace());
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[this.getRotation(state).get3DDataValue()];
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new PneumaticDynamoBlockEntity(pPos, pState);
    }
}

