/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketProgrammerSync;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ProgrammerBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    private static final VoxelShape SHAPE_N = VoxelShapeUtils.or(Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)10.0, (double)9.0, (double)11.0, (double)11.0, (double)15.0), Block.box((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)11.0, (double)7.0), Block.box((double)12.0, (double)10.0, (double)11.0, (double)15.0, (double)11.0, (double)15.0), Block.box((double)12.25, (double)10.0, (double)7.0, (double)12.75, (double)10.5, (double)11.0), Block.box((double)9.25, (double)10.0, (double)7.0, (double)9.75, (double)10.5, (double)9.0), Block.box((double)3.0, (double)10.5, (double)2.0, (double)13.0, (double)14.5, (double)4.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)8.0, (double)3.0), Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)3.0), Block.box((double)13.25, (double)10.0, (double)7.0, (double)13.75, (double)10.5, (double)11.0));
    private static final VoxelShape SHAPE_E = VoxelShapeUtils.rotateY(SHAPE_N, 90);
    private static final VoxelShape SHAPE_S = VoxelShapeUtils.rotateY(SHAPE_E, 90);
    private static final VoxelShape SHAPE_W = VoxelShapeUtils.rotateY(SHAPE_S, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_S, SHAPE_W, SHAPE_N, SHAPE_E};

    public ProgrammerBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction d = (Direction)state.getValue((Property)this.directionProperty());
        return SHAPES[d.get2DDataValue()];
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        if (!level.isClientSide && !player.isShiftKeyDown()) {
            PneumaticCraftUtils.getBlockEntityAt((BlockGetter)level, pos, ProgrammerBlockEntity.class).ifPresent(te -> NetworkHandler.sendToPlayer(PacketProgrammerSync.forBlockEntity(te), (ServerPlayer)player));
        }
        return super.useItemOn(heldItem, state, level, pos, player, hand, brtr);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ProgrammerBlockEntity(pPos, pState);
    }
}

