/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.stream.Stream;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.EmptySpawnerBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.spawning.SpawnerExtractorBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SpawnerExtractorBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    private static final VoxelShape SHAPE = Stream.of(Block.box((double)10.0, (double)12.0, (double)2.0, (double)11.0, (double)31.0, (double)3.0), Block.box((double)-0.5, (double)-2.5, (double)13.5, (double)16.5, (double)0.5, (double)16.5), Block.box((double)-0.5, (double)-2.5, (double)-0.5, (double)16.5, (double)0.5, (double)2.5), Block.box((double)-0.5, (double)-2.5, (double)2.5, (double)2.5, (double)0.5, (double)13.5), Block.box((double)13.5, (double)-2.5, (double)2.5, (double)16.5, (double)0.5, (double)13.5), Block.box((double)-0.5, (double)-13.5, (double)15.5, (double)0.5, (double)-2.5, (double)16.5), Block.box((double)-0.5, (double)-16.0, (double)13.5, (double)16.5, (double)-13.0, (double)16.5), Block.box((double)13.5, (double)-16.0, (double)2.5, (double)16.5, (double)-13.0, (double)13.5), Block.box((double)-0.5, (double)-16.0, (double)2.5, (double)2.5, (double)-13.0, (double)13.5), Block.box((double)-0.5, (double)-16.0, (double)-0.5, (double)16.5, (double)-13.0, (double)2.5), Block.box((double)-0.5, (double)-13.5, (double)13.5, (double)0.5, (double)-2.5, (double)14.5), Block.box((double)1.5, (double)-13.5, (double)15.5, (double)2.5, (double)-2.5, (double)16.5), Block.box((double)15.5, (double)-13.5, (double)13.5, (double)16.5, (double)-2.5, (double)14.5), Block.box((double)13.5, (double)-13.5, (double)15.5, (double)14.5, (double)-2.5, (double)16.5), Block.box((double)15.5, (double)-13.5, (double)15.5, (double)16.5, (double)-2.5, (double)16.5), Block.box((double)-0.5, (double)-13.5, (double)1.5, (double)0.5, (double)-2.5, (double)2.5), Block.box((double)-0.5, (double)-13.5, (double)-0.5, (double)0.5, (double)-2.5, (double)0.5), Block.box((double)1.5, (double)-13.5, (double)-0.5, (double)2.5, (double)-2.5, (double)0.5), Block.box((double)15.5, (double)-13.5, (double)1.5, (double)16.5, (double)-2.5, (double)2.5), Block.box((double)13.5, (double)-13.5, (double)-0.5, (double)14.5, (double)-2.5, (double)0.5), Block.box((double)15.5, (double)-13.5, (double)-0.5, (double)16.5, (double)-2.5, (double)0.5), Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)13.0, (double)1.0), Block.box((double)0.0, (double)12.0, (double)1.0, (double)1.0, (double)13.0, (double)15.0), Block.box((double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)13.0, (double)16.0), Block.box((double)1.0, (double)12.0, (double)0.0, (double)15.0, (double)13.0, (double)1.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)1.0), Block.box((double)15.0, (double)12.0, (double)1.0, (double)16.0, (double)13.0, (double)15.0), Block.box((double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)13.0, (double)16.0), Block.box((double)1.0, (double)12.0, (double)15.0, (double)15.0, (double)13.0, (double)16.0), Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0), Block.box((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)29.0, (double)11.0), Block.box((double)4.0, (double)29.0, (double)4.0, (double)12.0, (double)32.0, (double)12.0), Block.box((double)10.0, (double)30.0, (double)3.0, (double)11.0, (double)31.0, (double)4.0), Block.box((double)9.5, (double)29.5, (double)3.75, (double)11.5, (double)31.5, (double)4.75), Block.box((double)9.5, (double)11.25, (double)1.5, (double)11.5, (double)12.25, (double)3.5), Block.box((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)12.0, (double)15.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public SpawnerExtractorBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, SOUTH, WEST, EAST});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState below = worldIn.getBlockState(pos.below());
        return below.getBlock() instanceof SpawnerBlock || below.getBlock() instanceof EmptySpawnerBlock;
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(world, pos, state, entity, stack);
        world.getBlockEntity(pos, ModBlockEntityTypes.SPAWNER_EXTRACTOR.get()).ifPresent(SpawnerExtractorBlockEntity::updateMode);
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.canSurvive(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        worldIn.getBlockEntity(currentPos, ModBlockEntityTypes.SPAWNER_EXTRACTOR.get()).ifPresent(SpawnerExtractorBlockEntity::updateMode);
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new SpawnerExtractorBlockEntity(pPos, pState);
    }
}

