/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.lang.ref.WeakReference;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class SmartSyncTank
extends PNCFluidTank {
    @DescSynced
    private FluidStack syncedFluidStackDesc = FluidStack.EMPTY;
    @GuiSynced
    private FluidStack syncedFluidStackGui = FluidStack.EMPTY;
    private boolean pending = false;
    private int syncTimer = 0;
    private final WeakReference<BlockEntity> owner;
    private final int threshold;

    public SmartSyncTank(BlockEntity owner, int capacity) {
        super(capacity);
        this.owner = new WeakReference<BlockEntity>(owner);
        this.threshold = Math.min(1000, capacity / 100);
    }

    public void tick() {
        BlockEntity te = (BlockEntity)this.owner.get();
        if (te != null) {
            if (te.getLevel().isClientSide) {
                if (ClientUtils.isGuiOpen(te)) {
                    super.setFluid(this.syncedFluidStackGui);
                } else {
                    int currAmount = this.getFluidAmount();
                    FluidStack tgt = this.syncedFluidStackDesc;
                    int delta = tgt.getAmount() - currAmount;
                    if (delta != 0) {
                        int newAmount = Math.abs(delta) < this.capacity / 200 ? tgt.getAmount() : currAmount + delta / 20;
                        Fluid newFluid = this.fluidStack.isEmpty() ? tgt.getFluid() : this.fluidStack.getFluid();
                        super.setFluid(new FluidStack(newFluid, newAmount));
                    }
                }
            } else if (this.syncTimer > 0) {
                --this.syncTimer;
            } else if (this.syncTimer == 0) {
                if (this.pending) {
                    this.syncedFluidStackDesc = this.getFluid().copy();
                    this.pending = false;
                    this.syncTimer = (Integer)ConfigHelper.common().advanced.fluidTankUpdateRate.get();
                } else {
                    this.syncTimer = -1;
                }
            }
        }
    }

    private void deferredSync(int ticks) {
        if (this.syncTimer == -1) {
            this.syncedFluidStackDesc = this.getFluid().copy();
            this.syncTimer = ticks;
        } else {
            this.pending = true;
        }
    }

    private void onFluidChange(FluidStack newFluid) {
        this.syncedFluidStackGui = newFluid.copy();
        int delta = Math.abs(this.syncedFluidStackDesc.getAmount() - newFluid.getAmount());
        if (delta >= this.threshold || this.syncedFluidStackDesc.getFluid() != newFluid.getFluid()) {
            this.deferredSync((Integer)ConfigHelper.common().advanced.fluidTankUpdateRate.get());
        }
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int filled = super.fill(resource, action);
        if (filled != 0 && action.execute()) {
            this.onFluidChange(this.getFluid());
        }
        return filled;
    }

    @Override
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(resource, action);
        if (!drained.isEmpty() && action.execute()) {
            this.onFluidChange(this.getFluid());
        }
        return drained;
    }

    @Override
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(maxDrain, action);
        if (!drained.isEmpty() && action.execute()) {
            this.onFluidChange(this.getFluid());
        }
        return drained;
    }

    @Override
    protected void onContentsChanged(FluidStack prevStack) {
        BlockEntity be = (BlockEntity)this.owner.get();
        if (be != null && be.getLevel() != null && !be.getLevel().isClientSide()) {
            be.setChanged();
        }
    }

    @Override
    public void setFluid(FluidStack stack) {
        this.onFluidChange(stack);
        super.setFluid(stack);
    }

    @Override
    public void loadFromContent(SimpleFluidContent contents) {
        super.loadFromContent(contents);
        this.pending = true;
        this.syncedFluidStackGui = this.fluidStack.copy();
    }
}

