/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IActiveEntityHacks;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorRegistry;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class ActiveEntityHacks
implements IActiveEntityHacks,
INBTSerializable<CompoundTag> {
    private final Map<ResourceLocation, IHackableEntity<? extends Entity>> hacks = new HashMap<ResourceLocation, IHackableEntity<? extends Entity>>();

    @Override
    public void tick(Entity entity) {
        this.hacks.values().removeIf(hackable -> !hackable._afterHackTick(entity));
    }

    @Override
    public void addHackable(IHackableEntity<?> hackable) {
        this.hacks.put(hackable.getHackableId(), hackable);
    }

    @Override
    public Collection<IHackableEntity<?>> getCurrentHacks() {
        return this.hacks.values();
    }

    @Override
    public void clear() {
        this.hacks.clear();
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.getCurrentHacks().isEmpty() ? null : (CompoundTag)Util.make((Object)new CompoundTag(), compound -> compound.put("hackables", (Tag)Util.make((Object)new ListTag(), list -> {
            for (IHackableEntity<?> hackableEntity : this.getCurrentHacks()) {
                list.add((Object)((Tag)Util.make((Object)new CompoundTag(), t1 -> t1.putString("id", hackableEntity.getHackableId().toString()))));
            }
        })));
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.clear();
        ListTag tagList = nbt.getList("hackables", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            String id = tagList.getCompound(i).getString("id");
            ResourceLocation.read((String)id).result().ifPresentOrElse(hackableId -> CommonArmorRegistry.getInstance().getHackableEntityForId((ResourceLocation)hackableId).ifPresentOrElse(this::addHackable, () -> Log.error("entity-hackable '{}' not found when deserializing IHacking capability?", hackableId)), () -> Log.error("invalid hackable id '{}': not a resource location", id));
        }
    }
}

