/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIForEachCoordinate;
import me.desht.pneumaticcraft.common.drone.progwidgets.IJump;
import me.desht.pneumaticcraft.common.drone.progwidgets.IJumpBackWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetJump;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetForEachCoordinate
extends ProgWidgetAreaItemBase
implements IJumpBackWidget,
IJump,
IVariableSetWidget {
    public static final MapCodec<ProgWidgetForEachCoordinate> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetForEachCoordinate.baseParts(builder).and((App)Codec.STRING.optionalFieldOf("var", (Object)"").forGetter(ProgWidgetForEachCoordinate::getVariable)).apply((Applicative)builder, ProgWidgetForEachCoordinate::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetForEachCoordinate> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, (StreamCodec)ByteBufCodecs.STRING_UTF8, ProgWidgetForEachCoordinate::getVariable, ProgWidgetForEachCoordinate::new);
    private String elementVariable;
    private final Set<BlockPos> traversedPositions = new HashSet<BlockPos>();
    private DroneAIForEachCoordinate ai;

    private ProgWidgetForEachCoordinate(ProgWidget.PositionFields pos, String elementVariable) {
        super(pos);
        this.elementVariable = elementVariable;
    }

    public ProgWidgetForEachCoordinate() {
        this(ProgWidget.PositionFields.DEFAULT, "");
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetForEachCoordinate(this.getPosition(), this.elementVariable);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.YELLOW;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_FOR_EACH_COORDINATE;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.AREA.get(), ModProgWidgetTypes.TEXT.get());
    }

    @Override
    public void addVariables(Set<String> variables) {
        super.addVariables(variables);
        variables.add(this.elementVariable);
    }

    @Override
    public String getVariable() {
        return this.elementVariable;
    }

    @Override
    public void setVariable(String variable) {
        this.elementVariable = variable;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public IProgWidget getOutputWidget(IDrone drone, List<IProgWidget> allWidgets) {
        BlockPos pos;
        List<String> locations = this.getPossibleJumpLocations();
        BlockPos varPos = this.aiManager.getCoordinate(drone.getOwnerUUID(), this.elementVariable).orElse(PneumaticCraftUtils.invalidPos());
        if (!(locations.isEmpty() || this.ai == null || this.traversedPositions.size() != 1 && drone.getDroneLevel().isOutsideBuildHeight(varPos) || (pos = this.ai.getCurCoord()) == null)) {
            this.aiManager.setCoordinate(this.elementVariable, pos);
            return ProgWidgetJump.jumpToLabel(drone, allWidgets, locations.getFirst());
        }
        this.traversedPositions.clear();
        return super.getOutputWidget(drone, allWidgets);
    }

    @Override
    public List<String> getPossibleJumpLocations() {
        List<String> list;
        IProgWidget widget = this.getConnectedParameters()[this.getParameters().size() - 1];
        if (widget instanceof ProgWidgetText) {
            ProgWidgetText t = (ProgWidgetText)widget;
            list = Collections.singletonList(t.string);
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        this.ai = new DroneAIForEachCoordinate(drone, (ProgWidgetForEachCoordinate)widget);
        return this.ai;
    }

    public boolean isValidPosition(BlockPos pos) {
        return this.traversedPositions.add(pos);
    }

    @Override
    public boolean canBeRunByComputers(IDrone drone, IProgWidget widget) {
        return false;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.FOR_EACH_COORDINATE.get();
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return Collections.singletonList(this.varAsTextComponent(this.elementVariable));
    }

    @Override
    public boolean canSetParameter(int index) {
        return index != 2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgWidgetForEachCoordinate that = (ProgWidgetForEachCoordinate)o;
        return this.baseEquals(that) && Objects.equals(this.elementVariable, that.elementVariable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.elementVariable);
    }
}

