/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.progwidgets.IJump;
import me.desht.pneumaticcraft.common.drone.progwidgets.IJumpBackWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetJump;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetJumpSub
extends ProgWidget
implements IJumpBackWidget,
IJump {
    public static final MapCodec<ProgWidgetJumpSub> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetJumpSub.baseParts(builder).apply((Applicative)builder, ProgWidgetJumpSub::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetJumpSub> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetJumpSub::new);
    private boolean jumpBack;

    public ProgWidgetJumpSub(ProgWidget.PositionFields pos) {
        super(pos);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetJumpSub(this.getPosition());
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.JUMP_SUB.get();
    }

    public ProgWidgetJumpSub() {
        super(ProgWidget.PositionFields.DEFAULT);
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.label.error.noJumpLocation", new Object[0]));
        }
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public boolean hasStepOutput() {
        return true;
    }

    @Override
    public IProgWidget getOutputWidget(IDrone drone, List<IProgWidget> allWidgets) {
        List<String> locations = this.getPossibleJumpLocations();
        if (!locations.isEmpty() && !this.jumpBack) {
            this.jumpBack = true;
            return ProgWidgetJump.jumpToLabel(drone, allWidgets, locations.getFirst());
        }
        this.jumpBack = false;
        return super.getOutputWidget(drone, allWidgets);
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.TEXT.get());
    }

    @Override
    protected boolean hasBlacklist() {
        return false;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_JUMP_SUB;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.MEDIUM;
    }

    @Override
    public List<String> getPossibleJumpLocations() {
        ProgWidgetText jumpLabel = (ProgWidgetText)this.getConnectedParameters()[0];
        if (jumpLabel != null) {
            return Collections.singletonList(jumpLabel.string);
        }
        return Collections.emptyList();
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.WHITE;
    }
}

