/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAILiquidImport;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.drone.progwidgets.ILiquidFiltered;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetLiquidFilter;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class ProgWidgetLiquidImport
extends ProgWidgetInventoryBase
implements ILiquidFiltered,
IBlockOrdered {
    public static final MapCodec<ProgWidgetLiquidImport> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetLiquidImport.invParts(builder).and(builder.group((App)StringRepresentable.fromEnum(IBlockOrdered.Ordering::values).optionalFieldOf("order", (Object)IBlockOrdered.Ordering.HIGH_TO_LOW).forGetter(ProgWidgetLiquidImport::getOrder), (App)Codec.BOOL.optionalFieldOf("void_excess", (Object)false).forGetter(ProgWidgetLiquidImport::shouldVoidExcess))).apply((Applicative)builder, ProgWidgetLiquidImport::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetLiquidImport> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetInventoryBase.InvBaseFields.STREAM_CODEC, ProgWidgetInventoryBase::invBaseFields, (StreamCodec)NeoForgeStreamCodecs.enumCodec(IBlockOrdered.Ordering.class), ProgWidgetLiquidImport::getOrder, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetLiquidImport::shouldVoidExcess, ProgWidgetLiquidImport::new);
    private IBlockOrdered.Ordering order;
    private boolean voidExcess;

    private ProgWidgetLiquidImport(ProgWidget.PositionFields pos, ProgWidgetInventoryBase.InvBaseFields invBaseFields, IBlockOrdered.Ordering order, boolean voidExcess) {
        super(pos, invBaseFields);
        this.order = order;
        this.voidExcess = voidExcess;
    }

    public ProgWidgetLiquidImport() {
        this(ProgWidget.PositionFields.DEFAULT, ProgWidgetInventoryBase.InvBaseFields.DEFAULT, IBlockOrdered.Ordering.HIGH_TO_LOW, false);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetLiquidImport(this.getPosition(), this.invBaseFields().copy(), this.order, this.voidExcess);
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_LIQUID_IM;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.AREA.get(), ModProgWidgetTypes.LIQUID_FILTER.get());
    }

    @Override
    public boolean isFluidValid(Fluid fluid) {
        return ProgWidgetLiquidFilter.isLiquidValid(fluid, this, 1);
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneAILiquidImport<ProgWidgetInventoryBase>(drone, (ProgWidgetInventoryBase)widget);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.BLUE;
    }

    @Override
    public IBlockOrdered.Ordering getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(IBlockOrdered.Ordering order) {
        this.order = order;
    }

    public boolean shouldVoidExcess() {
        return this.voidExcess;
    }

    public void setVoidExcess(boolean voidExcess) {
        this.voidExcess = voidExcess;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.LIQUID_IMPORT.get();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.order", PneumaticCraftUtils.xlate(this.order.getTranslationKey(), new Object[0])));
        if (this.shouldVoidExcess()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.liquidImport.voidExcess", new Object[0]));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgWidgetLiquidImport that = (ProgWidgetLiquidImport)o;
        return this.baseEquals(that) && this.voidExcess == that.voidExcess && this.order == that.order;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.order, this.voidExcess);
    }
}

