/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.drone.area.AreaType;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeSerializer;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeWidget;
import me.desht.pneumaticcraft.api.drone.area.EnumOldAreaType;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetAreaTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class AreaTypeGrid
extends AreaType {
    public static final MapCodec<AreaTypeGrid> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("interval").forGetter(t -> t.interval)).apply((Applicative)builder, AreaTypeGrid::new));
    public static final StreamCodec<FriendlyByteBuf, AreaTypeGrid> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, t -> t.interval, AreaTypeGrid::new);
    public static final String ID = "grid";
    private int interval;

    public AreaTypeGrid(int interval) {
        super(ID);
        this.interval = interval;
    }

    public AreaTypeGrid() {
        this(0);
    }

    @Override
    public AreaType copy() {
        return new AreaTypeGrid(this.interval);
    }

    public String toString() {
        return this.getName() + "/" + this.interval;
    }

    @Override
    public AreaTypeSerializer<? extends AreaType> getSerializer() {
        return ModProgWidgetAreaTypes.AREA_TYPE_GRID.get();
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (p1.equals((Object)p2) || this.interval <= 0) {
            areaAdder.accept(p1);
        } else {
            for (int x = minX; x <= maxX; x += this.interval) {
                for (int y = minY; y <= maxY; y += this.interval) {
                    for (int z = minZ; z <= maxZ; z += this.interval) {
                        areaAdder.accept(new BlockPos(x, y, z));
                    }
                }
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaTypeWidget.IntegerField("pneumaticcraft.gui.progWidget.area.type.grid.interval", () -> this.interval, interval -> {
            this.interval = interval;
        }));
    }

    @Override
    public void convertFromLegacy(EnumOldAreaType oldAreaType, int typeInfo) {
        this.interval = typeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AreaTypeGrid that = (AreaTypeGrid)o;
        return this.interval == that.interval;
    }

    public int hashCode() {
        return Objects.hashCode(this.interval);
    }
}

