/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.fluid;

import me.desht.pneumaticcraft.common.PneumaticCraftAPIHandler;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.fluid.FuelRegistry;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.material.Fluid;

public class FluidSetup {
    public static void init() {
        PneumaticCraftAPIHandler api = PneumaticCraftAPIHandler.getInstance();
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            try {
                int temperature = fluid.getFluidType().getTemperature();
                if (temperature < (Integer)ConfigHelper.common().general.minFluidFuelTemperature.get() || !fluid.isSource(fluid.defaultFluidState())) continue;
                FuelRegistry.getInstance().registerHotFluid(fluid, (temperature - 300) * 40, 0.25f);
            }
            catch (RuntimeException e2) {
                ResourceLocation fluidId = BuiltInRegistries.FLUID.getKey((Object)fluid);
                Log.error("Caught exception while checking the fluid type of {}: {}", fluidId, e2.getMessage());
                Log.error("Looks like {} isn't setting a fluid type for this fluid, please report to the mod author", fluidId.getNamespace());
            }
        }
        api.getItemRegistry().registerMagnetSuppressor(e -> {
            ItemEntity ie;
            return e instanceof ItemEntity && (ie = (ItemEntity)e).getItem().getItem() == ModItems.EMPTY_PCB.get() && e.getCommandSenderWorld().getFluidState(e.blockPosition()).getType() == ModFluids.ETCHING_ACID.get();
        });
    }
}

