/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.HashSet;
import java.util.Objects;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TemperatureData {
    private final Double[] temp;
    private final boolean isMultisided;

    public static TemperatureData fromNBT(CompoundTag nbt) {
        Double[] temp = new Double[7];
        if (nbt.contains("heat")) {
            ListTag tagList = nbt.getList("heat", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag heatTag = tagList.getCompound(i);
                temp[heatTag.getByte((String)"side")] = heatTag.getInt("temp");
            }
            return new TemperatureData(true, temp);
        }
        temp[6] = nbt.getInt("temp");
        return new TemperatureData(false, temp);
    }

    public static TemperatureData forBlockEntity(BlockEntity provider) {
        HashSet heatExchangers = new HashSet();
        for (Direction face : DirectionUtil.VALUES) {
            IOHelper.getCap(provider, PNCCapabilities.HEAT_EXCHANGER_BLOCK, face).ifPresent(heatExchangers::add);
        }
        Double[] temp = new Double[7];
        if (heatExchangers.size() > 1) {
            for (Direction face : DirectionUtil.VALUES) {
                IOHelper.getCap(provider, PNCCapabilities.HEAT_EXCHANGER_BLOCK, face).ifPresent(h -> {
                    temp[face.get3DDataValue()] = h.getTemperature();
                });
            }
            return new TemperatureData(true, temp);
        }
        IOHelper.getCap(provider, PNCCapabilities.HEAT_EXCHANGER_BLOCK, null).ifPresent(h -> {
            temp[6] = h.getTemperature();
        });
        return new TemperatureData(false, temp);
    }

    private TemperatureData(boolean isMultisided, Double[] temp) {
        this.isMultisided = isMultisided;
        this.temp = temp;
    }

    public boolean isMultisided() {
        return this.isMultisided;
    }

    public double getTemperature(Direction face) {
        return Objects.requireNonNullElse(this.temp[this.getIdxForFace(face)], 0.0);
    }

    public int getTemperatureAsInt(Direction face) {
        return (int)this.getTemperature(face);
    }

    public boolean hasData(Direction face) {
        return this.temp[this.getIdxForFace(face)] != null;
    }

    private int getIdxForFace(Direction face) {
        return face == null ? 6 : face.get3DDataValue();
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.isMultisided()) {
            ListTag tagList = new ListTag();
            for (Direction face : DirectionUtil.VALUES) {
                if (!this.hasData(face)) continue;
                int temp = this.getTemperatureAsInt(face);
                tagList.add((Object)((Tag)Util.make((Object)new CompoundTag(), t -> {
                    t.putByte("side", (byte)face.get3DDataValue());
                    t.putInt("temp", temp);
                })));
            }
            nbt.put("heat", (Tag)tagList);
        } else {
            nbt.putInt("temp", this.getTemperatureAsInt(null));
        }
        return nbt;
    }
}

