/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.IDescSynced;
import me.desht.pneumaticcraft.common.network.SyncedField;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketDescription(BlockPos pos, boolean fullSync, List<IndexedField> fields, CompoundTag extraData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketDescription> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("description"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketDescription> STREAM_CODEC = StreamCodec.of(PacketDescription::toNetwork, PacketDescription::fromNetwork);
    public static final String NBT_EXTRA = "Extra";

    public static PacketDescription create(IDescSynced te, boolean fullSync, HolderLookup.Provider provider) {
        ArrayList<IndexedField> fields = new ArrayList<IndexedField>();
        List<SyncedField<?>> descFields = te.getDescriptionFields();
        for (int i = 0; i < descFields.size(); ++i) {
            if (!fullSync && !te.shouldSyncField(i)) continue;
            fields.add(new IndexedField(i, descFields.get(i).getFieldType(), descFields.get(i).getValue()));
        }
        CompoundTag extraData = (CompoundTag)Util.make((Object)new CompoundTag(), tag -> te.writeToPacket((CompoundTag)tag, provider));
        return new PacketDescription(te.getPosition(), fullSync, fields, extraData);
    }

    public static void toNetwork(RegistryFriendlyByteBuf buf, PacketDescription packet) {
        buf.writeBlockPos(packet.pos);
        buf.writeBoolean(packet.fullSync);
        buf.writeVarInt(packet.fields.size());
        for (IndexedField indexedField : packet.fields) {
            if (!packet.fullSync) {
                buf.writeVarInt(indexedField.idx);
            }
            buf.writeEnum((Enum)indexedField.type);
            SyncedField.toBytes(buf, indexedField.value, indexedField.type);
        }
        buf.writeNbt((Tag)packet.extraData);
    }

    public static PacketDescription fromNetwork(RegistryFriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        boolean fullSync = buf.readBoolean();
        int fieldCount = buf.readVarInt();
        ArrayList<IndexedField> fields = new ArrayList<IndexedField>();
        for (int i = 0; i < fieldCount; ++i) {
            int idx = fullSync ? i : buf.readVarInt();
            SyncedField.FieldType type = (SyncedField.FieldType)buf.readEnum(SyncedField.FieldType.class);
            fields.add(new IndexedField(idx, type, SyncedField.fromBytes(buf, type)));
        }
        CompoundTag extraData = buf.readNbt();
        return new PacketDescription(pos, fullSync, fields, extraData);
    }

    public CustomPacketPayload.Type<PacketDescription> type() {
        return TYPE;
    }

    public static void handle(PacketDescription message, IPayloadContext ctx) {
        message.processPacket(null, (HolderLookup.Provider)ctx.player().registryAccess());
    }

    public void processPacket(BlockEntity blockEntity, HolderLookup.Provider provider) {
        if (blockEntity == null) {
            if (!ClientUtils.getClientLevel().isLoaded(this.pos)) {
                return;
            }
            blockEntity = ClientUtils.getBlockEntity(this.pos);
        }
        if (blockEntity instanceof IDescSynced) {
            IDescSynced descSynced = (IDescSynced)blockEntity;
            List<SyncedField<?>> descFields = descSynced.getDescriptionFields();
            if (descFields != null) {
                for (IndexedField indexedField : this.fields) {
                    if (indexedField.idx >= descFields.size()) continue;
                    descFields.get(indexedField.idx).setValue(indexedField.value);
                }
            }
            descSynced.readFromPacket(this.extraData, provider);
            descSynced.onDescUpdate();
        }
    }

    public CompoundTag writeNBT(CompoundTag compound, RegistryAccess registryAccess) {
        CompoundTag subTag = new CompoundTag();
        if (!this.fields.isEmpty()) {
            subTag.putInt("Length", this.fields.size());
            RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), registryAccess, ConnectionType.NEOFORGE);
            ListTag list = new ListTag();
            for (IndexedField field : this.fields) {
                CompoundTag element = new CompoundTag();
                element.putByte("Type", (byte)field.type.ordinal());
                buf.clear();
                SyncedField.toBytes(buf, field.value, field.type);
                element.putByteArray("Value", Arrays.copyOf(buf.array(), buf.writerIndex()));
                list.add(list.size(), (Tag)element);
            }
            buf.release();
            subTag.put("Data", (Tag)list);
        }
        subTag.put(NBT_EXTRA, (Tag)this.extraData);
        compound.put("pneumaticcraft", (Tag)subTag);
        return compound;
    }

    public static PacketDescription fromNBT(CompoundTag compound, RegistryAccess registryAccess) {
        BlockPos pos = new BlockPos(compound.getInt("x"), compound.getInt("y"), compound.getInt("z"));
        boolean fullSync = true;
        CompoundTag subTag = compound.getCompound("pneumaticcraft");
        int fieldCount = subTag.getInt("Length");
        ArrayList<IndexedField> fields = new ArrayList<IndexedField>();
        if (fieldCount > 0) {
            ListTag list = subTag.getList("Data", 10);
            for (int i = 0; i < fieldCount; ++i) {
                CompoundTag element = list.getCompound(i);
                SyncedField.FieldType type = SyncedField.FieldType.values()[element.getByte("Type")];
                byte[] b = element.getByteArray("Value");
                RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])b), registryAccess, ConnectionType.NEOFORGE);
                fields.add(new IndexedField(i, type, SyncedField.fromBytes(buf, type)));
            }
        }
        CompoundTag extraData = subTag.getCompound(NBT_EXTRA);
        return new PacketDescription(pos, fullSync, fields, extraData);
    }

    public boolean hasData() {
        return !this.fields.isEmpty() || !this.extraData.isEmpty();
    }

    private record IndexedField(int idx, SyncedField.FieldType type, Object value) {
    }
}

