/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Optional;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketUtil {
    @Nonnull
    public static <T extends BlockEntity> Optional<T> getBlockEntity(Player player, BlockPos pos, Class<T> cls) {
        if (player == null || player.level().isClientSide) {
            return ClientUtils.getOptionalClientLevel().flatMap(level -> PneumaticCraftUtils.getBlockEntityAt((BlockGetter)level, pos, cls));
        }
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof AbstractPneumaticCraftMenu) {
            AbstractPneumaticCraftMenu pncMenu = (AbstractPneumaticCraftMenu)abstractContainerMenu;
            Object te = pncMenu.blockEntity;
            if (te != null && cls.isAssignableFrom(te.getClass()) && (pos == null || te.getBlockPos().equals((Object)pos))) {
                return Optional.of(te);
            }
        }
        return Optional.empty();
    }

    @Nonnull
    public static <T extends BlockEntity> Optional<T> getBlockEntity(Player player, Class<T> cls) {
        if (player.level().isClientSide) {
            throw new RuntimeException("don't call this method client side!");
        }
        return PacketUtil.getBlockEntity(player, null, cls);
    }
}

