/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.assembly;

import java.util.ArrayList;
import java.util.Collection;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.common.block.entity.processing.AssemblyControllerBlockEntity;
import me.desht.pneumaticcraft.common.item.AssemblyProgramItem;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.recipes.assembly.ProgramDrill;
import me.desht.pneumaticcraft.common.recipes.assembly.ProgramLaser;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ProgramDrillLaser
extends AssemblyProgram {
    @Override
    public AssemblyProgram.EnumMachine[] getRequiredMachines() {
        return new AssemblyProgram.EnumMachine[]{AssemblyProgram.EnumMachine.PLATFORM, AssemblyProgram.EnumMachine.IO_UNIT_EXPORT, AssemblyProgram.EnumMachine.IO_UNIT_IMPORT, AssemblyProgram.EnumMachine.DRILL, AssemblyProgram.EnumMachine.LASER};
    }

    @Override
    public boolean executeStep(AssemblyControllerBlockEntity.AssemblySystem system) {
        boolean useAir = true;
        Level world = system.getPlatform().getLevel();
        if (!system.getPlatform().getHeldStack().isEmpty()) {
            if (this.canItemBeDrilled(world, system.getPlatform().getHeldStack())) {
                system.getDrill().goDrilling();
            } else if (system.getDrill().isIdle() && this.canItemBeLasered(world, system.getPlatform().getHeldStack())) {
                system.getLaser().startLasering();
            } else if (system.getDrill().isIdle() && system.getLaser().isIdle()) {
                useAir = system.getExportUnit().pickupItem(null);
            }
        } else if (!system.getExportUnit().isIdle()) {
            useAir = system.getExportUnit().pickupItem(null);
        } else {
            ArrayList<AssemblyRecipe> recipes = new ArrayList<AssemblyRecipe>();
            recipes.addAll(this.getRecipeList(world));
            recipes.addAll(new ProgramDrill().getRecipeList(world));
            recipes.addAll(new ProgramLaser().getRecipeList(world));
            useAir = system.getImportUnit().pickupItem(recipes);
        }
        return useAir;
    }

    @Override
    public boolean validateBlockEntity(AssemblyControllerBlockEntity.AssemblySystem system) {
        return system.getDrill() != null && system.getLaser() != null;
    }

    private boolean canItemBeLasered(Level world, ItemStack item) {
        return ModRecipeTypes.ASSEMBLY_LASER.get().stream(world).anyMatch(recipe -> ((AssemblyRecipe)recipe.value()).matches(item));
    }

    private boolean canItemBeDrilled(Level world, ItemStack item) {
        return ModRecipeTypes.ASSEMBLY_DRILL.get().stream(world).anyMatch(recipe -> ((AssemblyRecipe)recipe.value()).matches(item));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
    }

    @Override
    public Collection<AssemblyRecipe> getRecipeList(Level level) {
        return ModRecipeTypes.ASSEMBLY_DRILL_LASER.get().allRecipes(level);
    }

    @Override
    public AssemblyProgramItem getItem() {
        return (AssemblyProgramItem)((Object)ModItems.ASSEMBLY_PROGRAM_DRILL_LASER.get());
    }
}

