/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.items.IItemHandler;

public class PressureChamberRecipeImpl
extends PressureChamberRecipe {
    private final float pressureRequired;
    private final List<SizedIngredient> inputs;
    private final List<ItemStack> outputs;
    private List<List<ItemStack>> displayStacks = null;

    public PressureChamberRecipeImpl(List<SizedIngredient> inputs, float pressureRequired, List<ItemStack> outputs) {
        this.inputs = List.copyOf(inputs);
        this.outputs = List.copyOf(outputs);
        this.pressureRequired = pressureRequired;
    }

    @Override
    public float getPressure() {
        return this.pressureRequired;
    }

    @Override
    public List<SizedIngredient> getInputs() {
        return this.inputs;
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public float getCraftingPressure(IItemHandler chamberHandler, IntList ingredientSlots) {
        return this.pressureRequired;
    }

    @Override
    public float getCraftingPressureForDisplay() {
        return this.pressureRequired;
    }

    @Override
    public IntCollection findIngredients(IItemHandler chamberHandler) {
        Set inputSet = Sets.newIdentityHashSet();
        inputSet.addAll(this.inputs);
        IntArrayList slots = new IntArrayList();
        for (int i = 0; i < chamberHandler.getSlots(); ++i) {
            if (chamberHandler.getStackInSlot(i).isEmpty()) continue;
            Iterator iter = inputSet.iterator();
            while (iter.hasNext()) {
                SizedIngredient ingr = (SizedIngredient)iter.next();
                if (!ingr.test(chamberHandler.getStackInSlot(i))) continue;
                iter.remove();
                slots.add(i);
                break;
            }
            if (slots.size() != this.inputs.size()) continue;
            return slots;
        }
        return IntList.of();
    }

    @Override
    public List<List<ItemStack>> getInputsForDisplay(HolderLookup.Provider provider) {
        if (this.displayStacks == null) {
            this.displayStacks = this.inputs.stream().map(ingredient -> Arrays.asList(ingredient.getItems())).toList();
        }
        return this.displayStacks;
    }

    @Override
    protected List<ItemStack> getSingleResultsForDisplay(HolderLookup.Provider provider) {
        return this.outputs;
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.PRESSURE_CHAMBER.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.PRESSURE_CHAMBER.get();
    }

    public String getGroup() {
        return "pneumaticcraft:pressure_chamber";
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.PRESSURE_CHAMBER_WALL.get());
    }

    @Override
    public boolean isValidInputItem(ItemStack stack) {
        ItemStack s2 = stack.copyWithCount(stack.getMaxStackSize());
        return this.inputs.stream().anyMatch(ingr -> ingr.test(s2));
    }

    @Override
    @Nonnull
    public List<ItemStack> craftRecipe(@Nonnull IItemHandler chamberHandler, IntList ingredientSlots, boolean simulate) {
        for (SizedIngredient ingredient : this.inputs) {
            int nItems = ingredient.getItems()[0].getCount();
            for (int i = 0; i < ingredientSlots.size() && nItems > 0; ++i) {
                int slot = ingredientSlots.getInt(i);
                if (!ingredient.test(chamberHandler.getStackInSlot(slot))) continue;
                ItemStack extracted = chamberHandler.extractItem(slot, nItems, simulate);
                nItems -= extracted.getCount();
            }
        }
        return this.outputs;
    }

    public static class Serializer<T extends PressureChamberRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("inputs").forGetter(PressureChamberRecipe::getInputs), (App)Codec.floatRange((float)-1.0f, (float)5.0f).fieldOf("pressure").forGetter(PressureChamberRecipe::getPressure), (App)ItemStack.CODEC.listOf().fieldOf("results").forGetter(PressureChamberRecipe::getOutputs)).apply((Applicative)builder, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), PressureChamberRecipe::getInputs, (StreamCodec)ByteBufCodecs.FLOAT, PressureChamberRecipe::getPressure, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), PressureChamberRecipe::getOutputs, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends PressureChamberRecipe> {
        public T create(List<SizedIngredient> var1, float var2, List<ItemStack> var3);
    }
}

