/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.other;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.desht.pneumaticcraft.api.crafting.recipe.FuelQualityRecipe;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;

public class FuelQualityRecipeImpl
extends FuelQualityRecipe {
    private final FluidIngredient fuel;
    private final int airPerBucket;
    private final float burnRate;

    public FuelQualityRecipeImpl(FluidIngredient fuel, int airPerBucket, float burnRate) {
        this.fuel = fuel;
        this.airPerBucket = airPerBucket;
        this.burnRate = burnRate;
    }

    @Override
    public boolean matchesFluid(Fluid inputFluid) {
        return this.fuel.test(new FluidStack(inputFluid, 1000));
    }

    @Override
    public FluidIngredient getFuel() {
        return this.fuel;
    }

    @Override
    public int getAirPerBucket() {
        return this.airPerBucket;
    }

    @Override
    public float getBurnRate() {
        return this.burnRate;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.FUEL_QUALITY.get();
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.FUEL_QUALITY.get();
    }

    public static class Serializer<T extends FuelQualityRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)FluidIngredient.CODEC_NON_EMPTY.fieldOf("fluid").forGetter(FuelQualityRecipe::getFuel), (App)ExtraCodecs.POSITIVE_INT.fieldOf("air_per_bucket").forGetter(FuelQualityRecipe::getAirPerBucket), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("burn_rate", (Object)Float.valueOf(1.0f)).forGetter(FuelQualityRecipe::getBurnRate)).apply((Applicative)builder, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)FluidIngredient.STREAM_CODEC, FuelQualityRecipe::getFuel, (StreamCodec)ByteBufCodecs.INT, FuelQualityRecipe::getAirPerBucket, (StreamCodec)ByteBufCodecs.FLOAT, FuelQualityRecipe::getBurnRate, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends FuelQualityRecipe> {
        public T create(FluidIngredient var1, int var2, float var3);
    }
}

