/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.registry;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.entity.drone.CollectorDroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.GuardDroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.HarvestingDroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.LogisticsDroneEntity;
import me.desht.pneumaticcraft.common.fluid.FluidPlastic;
import me.desht.pneumaticcraft.common.item.AbstractChestUpgradeKitItem;
import me.desht.pneumaticcraft.common.item.AirCanisterItem;
import me.desht.pneumaticcraft.common.item.AmadronTabletItem;
import me.desht.pneumaticcraft.common.item.AssemblyProgramItem;
import me.desht.pneumaticcraft.common.item.BandageItem;
import me.desht.pneumaticcraft.common.item.CamoApplicatorItem;
import me.desht.pneumaticcraft.common.item.ClassifyFilterItem;
import me.desht.pneumaticcraft.common.item.CompressedIronArmorItem;
import me.desht.pneumaticcraft.common.item.DrillBitItem;
import me.desht.pneumaticcraft.common.item.DroneItem;
import me.desht.pneumaticcraft.common.item.EmptyPCBItem;
import me.desht.pneumaticcraft.common.item.GPSAreaToolItem;
import me.desht.pneumaticcraft.common.item.GPSToolItem;
import me.desht.pneumaticcraft.common.item.GlycerolItem;
import me.desht.pneumaticcraft.common.item.JackHammerItem;
import me.desht.pneumaticcraft.common.item.ManometerItem;
import me.desht.pneumaticcraft.common.item.MemoryStickItem;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.common.item.NetworkComponentItem;
import me.desht.pneumaticcraft.common.item.NonDespawningItem;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.item.PneumaticCraftBucketItem;
import me.desht.pneumaticcraft.common.item.PneumaticWrenchItem;
import me.desht.pneumaticcraft.common.item.RemoteItem;
import me.desht.pneumaticcraft.common.item.SeismicSensorItem;
import me.desht.pneumaticcraft.common.item.SpawnerAgitatorItem;
import me.desht.pneumaticcraft.common.item.SpawnerCoreItem;
import me.desht.pneumaticcraft.common.item.TagFilterItem;
import me.desht.pneumaticcraft.common.item.TubeModuleItem;
import me.desht.pneumaticcraft.common.item.UpgradeItem;
import me.desht.pneumaticcraft.common.item.VortexCannonItem;
import me.desht.pneumaticcraft.common.item.logistics.LogisticsConfiguratorItem;
import me.desht.pneumaticcraft.common.item.logistics.LogisticsFrameActiveProviderItem;
import me.desht.pneumaticcraft.common.item.logistics.LogisticsFrameDefaultStorageItem;
import me.desht.pneumaticcraft.common.item.logistics.LogisticsFramePassiveProviderItem;
import me.desht.pneumaticcraft.common.item.logistics.LogisticsFrameRequesterItem;
import me.desht.pneumaticcraft.common.item.logistics.LogisticsFrameStorageItem;
import me.desht.pneumaticcraft.common.item.minigun.ArmorPiercingGunAmmoItem;
import me.desht.pneumaticcraft.common.item.minigun.ExplosiveGunAmmoItem;
import me.desht.pneumaticcraft.common.item.minigun.FreezingGunAmmoItem;
import me.desht.pneumaticcraft.common.item.minigun.IncendiaryGunAmmoItem;
import me.desht.pneumaticcraft.common.item.minigun.MinigunItem;
import me.desht.pneumaticcraft.common.item.minigun.StandardGunAmmoItem;
import me.desht.pneumaticcraft.common.item.minigun.WeightedGunAmmoItem;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import me.desht.pneumaticcraft.common.registry.ModFoods;
import me.desht.pneumaticcraft.common.semiblock.SemiblockItem;
import me.desht.pneumaticcraft.common.tubemodules.AirGrateModule;
import me.desht.pneumaticcraft.common.tubemodules.ChargingModule;
import me.desht.pneumaticcraft.common.tubemodules.FlowDetectorModule;
import me.desht.pneumaticcraft.common.tubemodules.LogisticsModule;
import me.desht.pneumaticcraft.common.tubemodules.PressureGaugeModule;
import me.desht.pneumaticcraft.common.tubemodules.RedstoneModule;
import me.desht.pneumaticcraft.common.tubemodules.RegulatorModule;
import me.desht.pneumaticcraft.common.tubemodules.SafetyValveModule;
import me.desht.pneumaticcraft.common.tubemodules.ThermostatModule;
import me.desht.pneumaticcraft.common.tubemodules.VacuumModule;
import me.desht.pneumaticcraft.common.upgrades.BuiltinUpgrade;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"pneumaticcraft");
    public static final DeferredItem<Item> COMPRESSED_IRON_INGOT = ModItems.register("ingot_iron_compressed");
    public static final DeferredItem<Item> PRESSURE_GAUGE = ModItems.register("pressure_gauge");
    public static final DeferredItem<Item> STONE_BASE = ModItems.register("stone_base");
    public static final DeferredItem<Item> CANNON_BARREL = ModItems.register("cannon_barrel");
    public static final DeferredItem<Item> TURBINE_BLADE = ModItems.register("turbine_blade");
    public static final DeferredItem<Item> PLASTIC = ModItems.register("plastic");
    public static final DeferredItem<Item> PNEUMATIC_CYLINDER = ModItems.register("pneumatic_cylinder");
    public static final DeferredItem<Item> TURBINE_ROTOR = ModItems.register("turbine_rotor");
    public static final DeferredItem<Item> PCB_BLUEPRINT = ModItems.register("pcb_blueprint");
    public static final DeferredItem<Item> TRANSISTOR = ModItems.register("transistor");
    public static final DeferredItem<Item> CAPACITOR = ModItems.register("capacitor");
    public static final DeferredItem<Item> PRINTED_CIRCUIT_BOARD = ModItems.register("printed_circuit_board");
    public static final DeferredItem<Item> SOLAR_WAFER = ModItems.register("solar_wafer");
    public static final DeferredItem<Item> SOLAR_CELL = ModItems.register("solar_cell");
    public static final DeferredItem<Item> STOP_WORM = ModItems.register("stop_worm");
    public static final DeferredItem<Item> NUKE_VIRUS = ModItems.register("nuke_virus");
    public static final DeferredItem<Item> COMPRESSED_IRON_GEAR = ModItems.register("compressed_iron_gear");
    public static final DeferredItem<Item> PROGRAMMING_PUZZLE = ModItems.register("programming_puzzle");
    public static final DeferredItem<Item> MODULE_EXPANSION_CARD = ModItems.register("module_expansion_card");
    public static final DeferredItem<Item> LOGISTICS_CORE = ModItems.register("logistics_core");
    public static final DeferredItem<Item> UPGRADE_MATRIX = ModItems.register("upgrade_matrix");
    public static final DeferredItem<Item> WHEAT_FLOUR = ModItems.register("wheat_flour");
    public static final DeferredItem<Item> SOURDOUGH = ModItems.register("sourdough");
    public static final DeferredItem<Item> SPAWNER_CORE_SHELL = ModItems.register("spawner_core_shell");
    public static final DeferredItem<Item> REINFORCED_CHEST_KIT = ModItems.register("reinforced_chest_kit", AbstractChestUpgradeKitItem.Reinforced::new);
    public static final DeferredItem<Item> SMART_CHEST_KIT = ModItems.register("smart_chest_kit", AbstractChestUpgradeKitItem.Smart::new);
    public static final DeferredItem<Item> RAW_SALMON_TEMPURA = ModItems.register("raw_salmon_tempura");
    public static final DeferredItem<Item> UNASSEMBLED_NETHERITE_DRILL_BIT = ModItems.register("unassembled_netherite_drill_bit");
    public static final DeferredItem<Item> COPPER_NUGGET = ModItems.register("copper_nugget");
    public static final DeferredItem<Item> SOURDOUGH_BREAD = ModItems.registerFood("sourdough_bread", ModFoods.SOURDOUGH);
    public static final DeferredItem<Item> CHIPS = ModItems.registerFood("chips", ModFoods.CHIPS);
    public static final DeferredItem<Item> COD_N_CHIPS = ModItems.registerFood("cod_n_chips", ModFoods.COD_N_CHIPS);
    public static final DeferredItem<Item> SALMON_TEMPURA = ModItems.registerFood("salmon_tempura", ModFoods.SALMON_TEMPURA);
    public static final DeferredItem<GPSToolItem> GPS_TOOL = ModItems.register("gps_tool", GPSToolItem::new);
    public static final DeferredItem<GPSAreaToolItem> GPS_AREA_TOOL = ModItems.register("gps_area_tool", GPSAreaToolItem::new);
    public static final DeferredItem<RemoteItem> REMOTE = ModItems.register("remote", RemoteItem::new);
    public static final DeferredItem<SeismicSensorItem> SEISMIC_SENSOR = ModItems.register("seismic_sensor", SeismicSensorItem::new);
    public static final DeferredItem<MicromissilesItem> MICROMISSILES = ModItems.register("micromissiles", MicromissilesItem::new);
    public static final DeferredItem<MemoryStickItem> MEMORY_STICK = ModItems.register("memory_stick", MemoryStickItem::new);
    public static final DeferredItem<TagFilterItem> TAG_FILTER = ModItems.register("tag_filter", TagFilterItem::new);
    public static final DeferredItem<ClassifyFilterItem> CLASSIFY_FILTER = ModItems.register("classify_filter", ClassifyFilterItem::new);
    public static final DeferredItem<GlycerolItem> GLYCEROL = ModItems.register("glycerol", GlycerolItem::new);
    public static final DeferredItem<BandageItem> BANDAGE = ModItems.register("bandage", BandageItem::new);
    public static final DeferredItem<SpawnerCoreItem> SPAWNER_CORE = ModItems.register("spawner_core", SpawnerCoreItem::new);
    public static final DeferredItem<AirCanisterItem> AIR_CANISTER = ModItems.register("air_canister", () -> new AirCanisterItem(AirCanisterItem.CanisterType.BASIC));
    public static final DeferredItem<AirCanisterItem> AIR_CANISTER_ARRAY = ModItems.register("air_canister_array", () -> new AirCanisterItem(AirCanisterItem.CanisterType.BASIC_ARRAY));
    public static final DeferredItem<AirCanisterItem> REINFORCED_AIR_CANISTER = ModItems.register("reinforced_air_canister", () -> new AirCanisterItem(AirCanisterItem.CanisterType.REINFORCED));
    public static final DeferredItem<AirCanisterItem> REINFORCED_AIR_CANISTER_ARRAY = ModItems.register("reinforced_air_canister_array", () -> new AirCanisterItem(AirCanisterItem.CanisterType.REINFORCED_ARRAY));
    public static final DeferredItem<VortexCannonItem> VORTEX_CANNON = ModItems.register("vortex_cannon", VortexCannonItem::new);
    public static final DeferredItem<PneumaticWrenchItem> PNEUMATIC_WRENCH = ModItems.register("pneumatic_wrench", PneumaticWrenchItem::new);
    public static final DeferredItem<ManometerItem> MANOMETER = ModItems.register("manometer", ManometerItem::new);
    public static final DeferredItem<LogisticsConfiguratorItem> LOGISTICS_CONFIGURATOR = ModItems.register("logistics_configurator", LogisticsConfiguratorItem::new);
    public static final DeferredItem<AmadronTabletItem> AMADRON_TABLET = ModItems.register("amadron_tablet", AmadronTabletItem::new);
    public static final DeferredItem<MinigunItem> MINIGUN = ModItems.register("minigun", MinigunItem::new);
    public static final DeferredItem<CamoApplicatorItem> CAMO_APPLICATOR = ModItems.register("camo_applicator", CamoApplicatorItem::new);
    public static final DeferredItem<JackHammerItem> JACKHAMMER = ModItems.register("jackhammer", JackHammerItem::new);
    public static final DeferredItem<Item> COMPRESSED_IRON_HELMET = ModItems.register("compressed_iron_helmet", () -> new CompressedIronArmorItem(ArmorItem.Type.HELMET));
    public static final DeferredItem<Item> COMPRESSED_IRON_CHESTPLATE = ModItems.register("compressed_iron_chestplate", () -> new CompressedIronArmorItem(ArmorItem.Type.CHESTPLATE));
    public static final DeferredItem<Item> COMPRESSED_IRON_LEGGINGS = ModItems.register("compressed_iron_leggings", () -> new CompressedIronArmorItem(ArmorItem.Type.LEGGINGS));
    public static final DeferredItem<Item> COMPRESSED_IRON_BOOTS = ModItems.register("compressed_iron_boots", () -> new CompressedIronArmorItem(ArmorItem.Type.BOOTS));
    public static final DeferredItem<PneumaticArmorItem> PNEUMATIC_HELMET = ModItems.register("pneumatic_helmet", () -> new PneumaticArmorItem(ArmorItem.Type.HELMET));
    public static final DeferredItem<PneumaticArmorItem> PNEUMATIC_CHESTPLATE = ModItems.register("pneumatic_chestplate", () -> new PneumaticArmorItem(ArmorItem.Type.CHESTPLATE));
    public static final DeferredItem<PneumaticArmorItem> PNEUMATIC_LEGGINGS = ModItems.register("pneumatic_leggings", () -> new PneumaticArmorItem(ArmorItem.Type.LEGGINGS));
    public static final DeferredItem<PneumaticArmorItem> PNEUMATIC_BOOTS = ModItems.register("pneumatic_boots", () -> new PneumaticArmorItem(ArmorItem.Type.BOOTS));
    public static final DeferredItem<AssemblyProgramItem> ASSEMBLY_PROGRAM_LASER = ModItems.register(AssemblyRecipe.AssemblyProgramType.LASER);
    public static final DeferredItem<AssemblyProgramItem> ASSEMBLY_PROGRAM_DRILL = ModItems.register(AssemblyRecipe.AssemblyProgramType.DRILL);
    public static final DeferredItem<AssemblyProgramItem> ASSEMBLY_PROGRAM_DRILL_LASER = ModItems.register(AssemblyRecipe.AssemblyProgramType.DRILL_LASER);
    public static final DeferredItem<EmptyPCBItem> EMPTY_PCB = ModItems.register("empty_pcb", EmptyPCBItem::new);
    public static final DeferredItem<NonDespawningItem> UNASSEMBLED_PCB = ModItems.register("unassembled_pcb", NonDespawningItem::new);
    public static final DeferredItem<NonDespawningItem> FAILED_PCB = ModItems.register("failed_pcb", NonDespawningItem::new);
    public static final DeferredItem<NetworkComponentItem> DIAGNOSTIC_SUBROUTINE = ModItems.register(NetworkComponentItem.NetworkComponentType.DIAGNOSTIC_SUBROUTINE);
    public static final DeferredItem<NetworkComponentItem> NETWORK_API = ModItems.register(NetworkComponentItem.NetworkComponentType.NETWORK_API);
    public static final DeferredItem<NetworkComponentItem> NETWORK_DATA_STORAGE = ModItems.register(NetworkComponentItem.NetworkComponentType.NETWORK_DATA_STORAGE);
    public static final DeferredItem<NetworkComponentItem> NETWORK_IO_PORT = ModItems.register(NetworkComponentItem.NetworkComponentType.NETWORK_IO_PORT);
    public static final DeferredItem<NetworkComponentItem> NETWORK_REGISTRY = ModItems.register(NetworkComponentItem.NetworkComponentType.NETWORK_REGISTRY);
    public static final DeferredItem<NetworkComponentItem> NETWORK_NODE = ModItems.register(NetworkComponentItem.NetworkComponentType.NETWORK_NODE);
    public static final DeferredItem<DrillBitItem> IRON_DRILL_BIT = ModItems.register(DrillBitItem.DrillBitType.IRON);
    public static final DeferredItem<DrillBitItem> COMPRESSED_IRON_DRILL_BIT = ModItems.register(DrillBitItem.DrillBitType.COMPRESSED_IRON);
    public static final DeferredItem<DrillBitItem> DIAMOND_DRILL_BIT = ModItems.register(DrillBitItem.DrillBitType.DIAMOND);
    public static final DeferredItem<DrillBitItem> NETHERITE_DRILL_BIT = ModItems.register(DrillBitItem.DrillBitType.NETHERITE);
    public static final DeferredItem<DroneItem> DRONE = ModItems.register("drone", () -> new DroneItem(DroneEntity::new, true, DyeColor.WHITE));
    public static final DeferredItem<DroneItem> LOGISTICS_DRONE = ModItems.register("logistics_drone", () -> new DroneItem(LogisticsDroneEntity::new, false, DyeColor.RED));
    public static final DeferredItem<DroneItem> HARVESTING_DRONE = ModItems.register("harvesting_drone", () -> new DroneItem(HarvestingDroneEntity::new, false, DyeColor.GREEN));
    public static final DeferredItem<DroneItem> GUARD_DRONE = ModItems.register("guard_drone", () -> new DroneItem(GuardDroneEntity::new, false, DyeColor.BLUE));
    public static final DeferredItem<DroneItem> COLLECTOR_DRONE = ModItems.register("collector_drone", () -> new DroneItem(CollectorDroneEntity::new, false, DyeColor.YELLOW));
    public static final DeferredItem<LogisticsFrameRequesterItem> LOGISTICS_FRAME_REQUESTER = ModItems.register("logistics_frame_requester", LogisticsFrameRequesterItem::new);
    public static final DeferredItem<LogisticsFrameStorageItem> LOGISTICS_FRAME_STORAGE = ModItems.register("logistics_frame_storage", LogisticsFrameStorageItem::new);
    public static final DeferredItem<LogisticsFrameDefaultStorageItem> LOGISTICS_FRAME_DEFAULT_STORAGE = ModItems.register("logistics_frame_default_storage", LogisticsFrameDefaultStorageItem::new);
    public static final DeferredItem<LogisticsFramePassiveProviderItem> LOGISTICS_FRAME_PASSIVE_PROVIDER = ModItems.register("logistics_frame_passive_provider", LogisticsFramePassiveProviderItem::new);
    public static final DeferredItem<LogisticsFrameActiveProviderItem> LOGISTICS_FRAME_ACTIVE_PROVIDER = ModItems.register("logistics_frame_active_provider", LogisticsFrameActiveProviderItem::new);
    public static final DeferredItem<SemiblockItem> HEAT_FRAME = ModItems.register("heat_frame", SemiblockItem::new);
    public static final DeferredItem<SemiblockItem> SPAWNER_AGITATOR = ModItems.register("spawner_agitator", SpawnerAgitatorItem::new);
    public static final DeferredItem<SemiblockItem> CROP_SUPPORT = ModItems.register("crop_support", SemiblockItem::new);
    public static final DeferredItem<SemiblockItem> TRANSFER_GADGET = ModItems.register("transfer_gadget", SemiblockItem::new);
    public static final DeferredItem<StandardGunAmmoItem> GUN_AMMO = ModItems.register("gun_ammo", StandardGunAmmoItem::new);
    public static final DeferredItem<IncendiaryGunAmmoItem> GUN_AMMO_INCENDIARY = ModItems.register("gun_ammo_incendiary", IncendiaryGunAmmoItem::new);
    public static final DeferredItem<WeightedGunAmmoItem> GUN_AMMO_WEIGHTED = ModItems.register("gun_ammo_weighted", WeightedGunAmmoItem::new);
    public static final DeferredItem<ArmorPiercingGunAmmoItem> GUN_AMMO_AP = ModItems.register("gun_ammo_ap", ArmorPiercingGunAmmoItem::new);
    public static final DeferredItem<ExplosiveGunAmmoItem> GUN_AMMO_EXPLOSIVE = ModItems.register("gun_ammo_explosive", ExplosiveGunAmmoItem::new);
    public static final DeferredItem<FreezingGunAmmoItem> GUN_AMMO_FREEZING = ModItems.register("gun_ammo_freezing", FreezingGunAmmoItem::new);
    public static final DeferredItem<TubeModuleItem> SAFETY_TUBE_MODULE = ModItems.register("safety_tube_module", () -> new TubeModuleItem(SafetyValveModule::new));
    public static final DeferredItem<TubeModuleItem> PRESSURE_GAUGE_MODULE = ModItems.register("pressure_gauge_module", () -> new TubeModuleItem(PressureGaugeModule::new));
    public static final DeferredItem<TubeModuleItem> FLOW_DETECTOR_MODULE = ModItems.register("flow_detector_module", () -> new TubeModuleItem(FlowDetectorModule::new));
    public static final DeferredItem<TubeModuleItem> AIR_GRATE_MODULE = ModItems.register("air_grate_module", () -> new TubeModuleItem(AirGrateModule::new));
    public static final DeferredItem<TubeModuleItem> REGULATOR_TUBE_MODULE = ModItems.register("regulator_tube_module", () -> new TubeModuleItem(RegulatorModule::new));
    public static final DeferredItem<TubeModuleItem> CHARGING_MODULE = ModItems.register("charging_module", () -> new TubeModuleItem(ChargingModule::new));
    public static final DeferredItem<TubeModuleItem> LOGISTICS_MODULE = ModItems.register("logistics_module", () -> new TubeModuleItem(LogisticsModule::new));
    public static final DeferredItem<TubeModuleItem> REDSTONE_MODULE = ModItems.register("redstone_module", () -> new TubeModuleItem(RedstoneModule::new));
    public static final DeferredItem<TubeModuleItem> VACUUM_MODULE = ModItems.register("vacuum_module", () -> new TubeModuleItem(VacuumModule::new));
    public static final DeferredItem<TubeModuleItem> THERMOSTAT_MODULE = ModItems.register("thermostat_module", () -> new TubeModuleItem(ThermostatModule::new));
    public static final DeferredItem<BucketItem> OIL_BUCKET = ModItems.registerBucket("oil_bucket", ModFluids.OIL);
    public static final DeferredItem<BucketItem> ETCHING_ACID_BUCKET = ModItems.registerBucket("etching_acid_bucket", ModFluids.ETCHING_ACID);
    public static final DeferredItem<BucketItem> PLASTIC_BUCKET = ModItems.register("plastic_bucket", FluidPlastic.Bucket::new);
    public static final DeferredItem<BucketItem> DIESEL_BUCKET = ModItems.registerBucket("diesel_bucket", ModFluids.DIESEL);
    public static final DeferredItem<BucketItem> KEROSENE_BUCKET = ModItems.registerBucket("kerosene_bucket", ModFluids.KEROSENE);
    public static final DeferredItem<BucketItem> GASOLINE_BUCKET = ModItems.registerBucket("gasoline_bucket", ModFluids.GASOLINE);
    public static final DeferredItem<BucketItem> LPG_BUCKET = ModItems.registerBucket("lpg_bucket", ModFluids.LPG);
    public static final DeferredItem<BucketItem> LUBRICANT_BUCKET = ModItems.registerBucket("lubricant_bucket", ModFluids.LUBRICANT);
    public static final DeferredItem<BucketItem> MEMORY_ESSENCE_BUCKET = ModItems.registerBucket("memory_essence_bucket", ModFluids.MEMORY_ESSENCE);
    public static final DeferredItem<BucketItem> YEAST_CULTURE_BUCKET = ModItems.registerBucket("yeast_culture_bucket", ModFluids.YEAST_CULTURE);
    public static final DeferredItem<BucketItem> ETHANOL_BUCKET = ModItems.registerBucket("ethanol_bucket", ModFluids.ETHANOL);
    public static final DeferredItem<BucketItem> VEGETABLE_OIL_BUCKET = ModItems.registerBucket("vegetable_oil_bucket", ModFluids.VEGETABLE_OIL);
    public static final DeferredItem<BucketItem> BIODIESEL_BUCKET = ModItems.registerBucket("biodiesel_bucket", ModFluids.BIODIESEL);

    public static Item.Properties defaultProps() {
        return new Item.Properties();
    }

    public static Item.Properties toolProps() {
        return ModItems.defaultProps().stacksTo(1);
    }

    public static Item.Properties pressurizableProps() {
        return ModItems.defaultProps().component(ModDataComponents.AIR, (Object)0);
    }

    public static Item.Properties pressurizableToolProps() {
        return ModItems.toolProps().component(ModDataComponents.AIR, (Object)0);
    }

    public static Item.Properties filledBucketProps() {
        return ModItems.defaultProps().stacksTo(1).craftRemainder(Items.BUCKET);
    }

    public static <T extends Item> DeferredItem<T> register(String name, Supplier<T> sup) {
        return ITEMS.register(name, sup);
    }

    private static DeferredItem<NetworkComponentItem> register(NetworkComponentItem.NetworkComponentType type) {
        return ModItems.register(type.getRegistryName(), () -> new NetworkComponentItem(type));
    }

    private static DeferredItem<AssemblyProgramItem> register(AssemblyRecipe.AssemblyProgramType type) {
        return ModItems.register(type.getRegistryName(), () -> new AssemblyProgramItem(type));
    }

    private static DeferredItem<DrillBitItem> register(DrillBitItem.DrillBitType type) {
        return ModItems.register(type.getRegistryName(), () -> new DrillBitItem(type));
    }

    private static DeferredItem<Item> register(String name) {
        return ModItems.register(name, () -> new Item(ModItems.defaultProps()));
    }

    private static DeferredItem<BucketItem> registerBucket(String name, Supplier<? extends Fluid> sup) {
        return ModItems.register(name, () -> new PneumaticCraftBucketItem((Fluid)sup.get()));
    }

    private static DeferredItem<Item> registerFood(String name, FoodProperties food) {
        return ModItems.register(name, () -> new Item(ModItems.defaultProps().food(food)));
    }

    private static void registerUpgrade(BuiltinUpgrade builtin) {
        PNCUpgrade pncUpgrade = builtin.registerUpgrade();
        IntStream.rangeClosed(1, builtin.getMaxTier()).forEach(tier -> ModItems.register(pncUpgrade.getItemRegistryName(tier).getPath(), () -> new UpgradeItem(pncUpgrade, tier, builtin.getRarity())));
    }

    static {
        for (BuiltinUpgrade bu : BuiltinUpgrade.values()) {
            ModItems.registerUpgrade(bu);
        }
    }
}

