/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.immersiveengineering;

import blusunrize.immersiveengineering.api.Lib;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.joml.Vector3f;

public class ElectricAttackHandler {
    private static final Map<UUID, Long> sounds = new HashMap<UUID, Long>();

    public static void onElectricalAttack(LivingIncomingDamageEvent event) {
        if (!event.getSource().is(Lib.DamageTypes.WIRE_SHOCK)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof DroneEntity) {
            DroneEntity drone = (DroneEntity)livingEntity;
            if (drone.getUpgrades(ModUpgrades.SECURITY.get()) > 0) {
                float dmg = event.getAmount();
                ((IAirHandler)drone.getCapability(PNCCapabilities.AIR_HANDLER_ENTITY)).addAir((int)(-50.0f * dmg));
                float dy = Math.min(dmg / 4.0f, 0.5f);
                NetworkHandler.sendToAllTracking((CustomPacketPayload)new PacketSpawnParticle(AirParticleData.DENSE, drone.position().toVector3f(), new Vector3f(0.0f, -dy, 0.0f), (int)dmg, Optional.empty()), (Entity)drone);
                event.setAmount(0.0f);
                ElectricAttackHandler.playLeakSound((Entity)drone);
            }
        } else {
            Player player;
            CommonArmorHandler handler;
            LivingEntity dmg = event.getEntity();
            if (dmg instanceof Player && (handler = CommonArmorHandler.getHandlerForPlayer(player = (Player)dmg)).getUpgradeCount(EquipmentSlot.CHEST, ModUpgrades.SECURITY.get()) > 0 && (double)handler.getArmorPressure(EquipmentSlot.CHEST) > 0.1 && handler.isArmorReady(EquipmentSlot.CHEST)) {
                handler.addAir(EquipmentSlot.CHEST, (int)(-150.0f * event.getAmount()));
                float sx = player.getRandom().nextFloat() * 1.5f - 0.75f;
                float sz = player.getRandom().nextFloat() * 1.5f - 0.75f;
                float dy = Math.min(event.getAmount() / 4.0f, 0.5f);
                NetworkHandler.sendToAllTracking(PacketSpawnParticle.oneParticle(AirParticleData.DENSE, player.position().toVector3f().add(sx, 1.0f, sz), new Vector3f(sx / 4.0f, -dy, sz / 4.0f)), player.level(), player.blockPosition());
                event.setAmount(0.0f);
                ElectricAttackHandler.playLeakSound((Entity)player);
            }
        }
    }

    private static void playLeakSound(Entity e) {
        if (e.level().getGameTime() - sounds.getOrDefault(e.getUUID(), 0L) > 16L) {
            e.level().playSound(null, e.blockPosition(), (SoundEvent)ModSounds.LEAKING_GAS.get(), SoundSource.PLAYERS, 0.5f, 0.7f);
            sounds.put(e.getUUID(), e.level().getGameTime());
        }
    }
}

