/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.block.PressureChamberInterfaceBlock;
import me.desht.pneumaticcraft.common.block.PressureChamberValveBlock;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.FluidStackVariableSerializer;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.Patchouli;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableSerializer;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.api.VariableHelper;

public class PatchouliAccess {
    public static void setup() {
        PatchouliAPI.IPatchouliAPI papi = PatchouliAPI.get();
        PatchouliAccess.setConfigFlags();
        IStateMatcher edge = papi.predicateMatcher((Block)ModBlocks.PRESSURE_CHAMBER_WALL.get(), PatchouliAccess::validEdge);
        IStateMatcher wall = papi.predicateMatcher((Block)ModBlocks.PRESSURE_CHAMBER_WALL.get(), PatchouliAccess::validFace);
        IStateMatcher glass = papi.predicateMatcher((Block)ModBlocks.PRESSURE_CHAMBER_GLASS.get(), PatchouliAccess::validFace);
        IStateMatcher valve = papi.predicateMatcher((BlockState)((PressureChamberValveBlock)ModBlocks.PRESSURE_CHAMBER_VALVE.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH), PatchouliAccess::validFace);
        IStateMatcher valveUp = papi.predicateMatcher((BlockState)((PressureChamberValveBlock)ModBlocks.PRESSURE_CHAMBER_VALVE.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP), PatchouliAccess::validFace);
        IStateMatcher intI = papi.predicateMatcher((BlockState)((PressureChamberInterfaceBlock)ModBlocks.PRESSURE_CHAMBER_INTERFACE.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST), PatchouliAccess::validFace);
        IStateMatcher intO = papi.predicateMatcher((BlockState)((PressureChamberInterfaceBlock)ModBlocks.PRESSURE_CHAMBER_INTERFACE.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST), PatchouliAccess::validFace);
        IMultiblock pc3 = papi.makeMultiblock((String[][])new String[][]{{"WWW", "WWW", "WWW"}, {"WIW", "VAF", "WIW"}, {"WWW", "W0W", "WWW"}}, new Object[]{Character.valueOf('W'), edge, Character.valueOf('F'), glass, Character.valueOf('0'), wall, Character.valueOf('V'), valve, Character.valueOf('I'), intI, Character.valueOf('O'), intO, Character.valueOf('A'), papi.airMatcher()}).setSymmetrical(true);
        papi.registerMultiblock(PneumaticRegistry.RL("pressure_chamber_3"), pc3);
        IMultiblock pc4 = papi.makeMultiblock((String[][])new String[][]{{"WWWW", "WWWW", "WWWW", "WWWW"}, {"WFFW", "VAAF", "FAAF", "WFFW"}, {"WFFW", "VAAF", "FAAF", "WIOW"}, {"WWWW", "W0WW", "WWWW", "WWWW"}}, new Object[]{Character.valueOf('W'), edge, Character.valueOf('F'), glass, Character.valueOf('0'), wall, Character.valueOf('V'), valve, Character.valueOf('I'), intI, Character.valueOf('O'), intO, Character.valueOf('A'), papi.airMatcher()}).setSymmetrical(false);
        papi.registerMultiblock(PneumaticRegistry.RL("pressure_chamber_4"), pc4);
        IMultiblock pc5 = papi.makeMultiblock((String[][])new String[][]{{"WWWWW", "WWVWW", "WVWVW", "WWVWW", "WWWWW"}, {"WFFFW", "FAAAF", "FAAAF", "FAAAF", "WOFIW"}, {"WFFFW", "FAAAF", "FAAAF", "FAAAF", "WFFFW"}, {"WFFFW", "FAAAF", "FAAAF", "FAAAF", "WOFIW"}, {"WWWWW", "WWWWW", "WW0WW", "WWWWW", "WWWWW"}}, new Object[]{Character.valueOf('W'), edge, Character.valueOf('F'), glass, Character.valueOf('0'), wall, Character.valueOf('V'), valveUp, Character.valueOf('I'), intI, Character.valueOf('O'), intO, Character.valueOf('A'), papi.airMatcher()}).setSymmetrical(true);
        papi.registerMultiblock(PneumaticRegistry.RL("pressure_chamber_5"), pc5);
        VariableHelper.instance().registerSerializer((IVariableSerializer)new FluidStackVariableSerializer(), FluidStack.class);
    }

    private static boolean validEdge(BlockState state) {
        return state.getBlock() == ModBlocks.PRESSURE_CHAMBER_WALL.get() || state.getBlock() == ModBlocks.PRESSURE_CHAMBER_GLASS.get();
    }

    private static boolean validFace(BlockState state) {
        return state.getBlock() == ModBlocks.PRESSURE_CHAMBER_WALL.get() || state.getBlock() == ModBlocks.PRESSURE_CHAMBER_GLASS.get() || state.getBlock() == ModBlocks.PRESSURE_CHAMBER_INTERFACE.get() || state.getBlock() == ModBlocks.PRESSURE_CHAMBER_VALVE.get();
    }

    static void setConfigFlags() {
        PatchouliAPI.IPatchouliAPI papi = PatchouliAPI.get();
        papi.setConfigFlag("pneumaticcraft:inWorldPlasticSolidification", ((Boolean)ConfigHelper.common().recipes.inWorldPlasticSolidification.get()).booleanValue());
        papi.setConfigFlag("pneumaticcraft:inWorldYeastCrafting", ((Boolean)ConfigHelper.common().recipes.inWorldYeastCrafting.get()).booleanValue());
        papi.setConfigFlag("pneumaticcraft:liquidHopperDispenser", ((Boolean)ConfigHelper.common().machines.liquidHopperDispenser.get()).booleanValue());
        papi.setConfigFlag("pneumaticcraft:omniHopperDispenser", ((Boolean)ConfigHelper.common().machines.omniHopperDispenser.get()).booleanValue());
        papi.setConfigFlag("pneumaticcraft:securityStationHacking", ((Boolean)ConfigHelper.common().machines.securityStationAllowHacking.get()).booleanValue());
        papi.setConfigFlag("pneumaticcraft:electricCompressorEnabled", false);
        papi.setConfigFlag("pneumaticcraft:pneumaticGeneratorEnabled", false);
    }

    static boolean openBookEntry(ResourceLocation page) {
        PatchouliAPI.get().openBookEntry(Patchouli.PNC_BOOK, page, 1);
        return Patchouli.PNC_BOOK.equals((Object)PatchouliAPI.get().getOpenBookGui());
    }

    static IVariable getStacks(SizedIngredient ingr, HolderLookup.Provider lookup) {
        return IVariable.wrapList(Arrays.stream(ingr.getItems()).map(object -> IVariable.from((Object)object, (HolderLookup.Provider)lookup)).toList(), (HolderLookup.Provider)lookup);
    }

    static IVariable getStacks(Ingredient ingr, HolderLookup.Provider lookup) {
        return IVariable.wrapList(Arrays.stream(ingr.getItems()).map(object -> IVariable.from((Object)object, (HolderLookup.Provider)lookup)).toList(), (HolderLookup.Provider)lookup);
    }

    static IVariable getStacks(List<ItemStack> stacks, HolderLookup.Provider lookup) {
        return IVariable.wrapList(stacks.stream().map(object -> IVariable.from((Object)object, (HolderLookup.Provider)lookup)).toList(), (HolderLookup.Provider)lookup);
    }

    public static IVariable getFluidStacks(SizedFluidIngredient ingr, HolderLookup.Provider lookup) {
        return IVariable.wrapList(Arrays.stream(ingr.getFluids()).map(object -> IVariable.from((Object)object, (HolderLookup.Provider)lookup)).toList(), (HolderLookup.Provider)lookup);
    }
}

