/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.tubemodule.AbstractTubeModuleScreen;
import me.desht.pneumaticcraft.common.block.PressureTubeBlock;
import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.INetworkedModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractTubeModule {
    public static final float MAX_VALUE = 30.0f;
    protected final PressureTubeBlockEntity pressureTube;
    private final VoxelShape[] boundingBoxes;
    protected final Direction dir;
    private boolean fake;
    private boolean shouldDrop;
    protected boolean upgraded;
    public float lowerBound = 4.9f;
    public float higherBound = 0.0f;
    public boolean advancedConfig;
    private ResourceLocation regName;

    public AbstractTubeModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        this.dir = dir;
        this.pressureTube = pressureTube;
        double w = this.getWidth() / 2.0;
        double h = this.getHeight();
        this.boundingBoxes = new VoxelShape[]{Block.box((double)(8.0 - w), (double)(6.0 - h), (double)(8.0 - w), (double)(8.0 + w), (double)6.0, (double)(8.0 + w)), Block.box((double)(8.0 - w), (double)10.0, (double)(8.0 - w), (double)(8.0 + w), (double)(10.0 + h), (double)(8.0 + w)), Block.box((double)(8.0 - w), (double)(8.0 - w), (double)(6.0 - h), (double)(8.0 + w), (double)(8.0 + w), (double)6.0), Block.box((double)(8.0 - w), (double)(8.0 - w), (double)10.0, (double)(8.0 + w), (double)(8.0 + w), (double)(10.0 + h)), Block.box((double)(6.0 - h), (double)(8.0 - w), (double)(8.0 - w), (double)6.0, (double)(8.0 + w), (double)(8.0 + w)), Block.box((double)10.0, (double)(8.0 - w), (double)(8.0 - w), (double)(10.0 + h), (double)(8.0 + w), (double)(8.0 + w))};
    }

    public int getInternalId() {
        return BuiltInRegistries.ITEM.getId((Object)this.getItem());
    }

    public void markFake() {
        this.fake = true;
    }

    public boolean isFake() {
        return this.fake;
    }

    public PressureTubeBlockEntity getTube() {
        return this.pressureTube;
    }

    public boolean isValid() {
        return !this.pressureTube.isRemoved();
    }

    protected final void setChanged() {
        if (this.pressureTube != null && this.pressureTube.getLevel() != null && !this.pressureTube.getLevel().isClientSide) {
            this.pressureTube.setChanged();
        }
    }

    public double getWidth() {
        return 4.0;
    }

    protected double getHeight() {
        return 6.0;
    }

    public float getThreshold(int redstone) {
        double slope = (this.higherBound - this.lowerBound) / 15.0f;
        double threshold = (double)this.lowerBound + slope * (double)redstone;
        return (float)threshold;
    }

    public NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.create();
        if (this.shouldDrop) {
            drops.add((Object)new ItemStack((ItemLike)this.getItem()));
            if (this.upgraded) {
                drops.add((Object)new ItemStack((ItemLike)ModItems.MODULE_EXPANSION_CARD.get()));
            }
        }
        return drops;
    }

    public abstract Item getItem();

    public Direction getDirection() {
        return this.dir;
    }

    public void readFromNBT(CompoundTag nbt) {
        this.lowerBound = nbt.getFloat("lowerBound");
        this.higherBound = nbt.getFloat("higherBound");
        this.upgraded = nbt.getBoolean("upgraded");
        this.advancedConfig = nbt.getBoolean("advancedConfig");
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.putInt("dir", this.dir.get3DDataValue());
        nbt.putFloat("lowerBound", this.lowerBound);
        nbt.putFloat("higherBound", this.higherBound);
        if (this.upgraded) {
            nbt.putBoolean("upgraded", true);
        }
        if (this.advancedConfig) {
            nbt.putBoolean("advancedConfig", true);
        }
        return nbt;
    }

    protected void tickCommon() {
    }

    public void tickClient() {
        this.tickCommon();
    }

    public void tickServer() {
        this.shouldDrop = true;
        this.tickCommon();
    }

    public void onNeighborTileUpdate() {
    }

    public void onNeighborBlockUpdate() {
    }

    public final ResourceLocation getType() {
        if (this.regName == null) {
            this.regName = PneumaticCraftUtils.getRegistryName(this.getItem()).orElseThrow();
        }
        return this.regName;
    }

    public int getRedstoneLevel() {
        return 0;
    }

    public void updateNeighbors() {
        Level level = this.pressureTube.nonNullLevel();
        BlockPos pos = this.pressureTube.getBlockPos();
        level.updateNeighborsAt(pos, level.getBlockState(pos).getBlock());
    }

    public boolean isInline() {
        return false;
    }

    public void sendDescriptionPacket() {
        this.pressureTube.sendDescriptionPacket();
    }

    public void addInfo(List<Component> curInfo) {
        if (this.upgraded) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.MODULE_EXPANSION_CARD.get());
            curInfo.add((Component)stack.getHoverName().copy().append(" installed").withStyle(ChatFormatting.GREEN));
        }
        if (this instanceof INetworkedModule) {
            int colorChannel = ((INetworkedModule)((Object)this)).getColorChannel();
            String key = "color.minecraft." + String.valueOf(DyeColor.byId((int)colorChannel));
            curInfo.add((Component)Component.translatable((String)"pneumaticcraft.waila.logisticsModule.channel").append(" ").append((Component)Component.translatable((String)key).withStyle(ChatFormatting.YELLOW)));
        }
    }

    public boolean canUpgrade() {
        return true;
    }

    public void upgrade() {
        if (!this.upgraded) {
            this.setChanged();
            this.upgraded = true;
        }
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public boolean onActivated(Player player, InteractionHand hand) {
        if (player.level().isClientSide && this.hasGui()) {
            AbstractTubeModuleScreen.openGuiForModule(this);
        }
        return true;
    }

    public boolean hasGui() {
        return false;
    }

    public VoxelShape getShape() {
        return this.boundingBoxes[this.getDirection().get3DDataValue()];
    }

    public AABB getRenderBoundingBox() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractTubeModule)) {
            return false;
        }
        AbstractTubeModule that = (AbstractTubeModule)o;
        return Objects.equals(this.pressureTube.getBlockPos(), that.pressureTube.getBlockPos()) && this.dir == that.dir;
    }

    public int hashCode() {
        return Objects.hash(this.pressureTube.getBlockPos(), this.dir);
    }

    public void onPlaced() {
    }

    public void onRemoved() {
    }

    public boolean isInlineAndFocused(PressureTubeBlock.TubeHitInfo hitInfo) {
        return false;
    }

    public boolean canConnectTo(AbstractTubeModule other) {
        return this.getClass() == other.getClass();
    }
}

