/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class IOHelper {
    public static Optional<IItemHandler> getInventoryForBlock(BlockEntity te, Direction facing) {
        return IOHelper.getCap(te, Capabilities.ItemHandler.BLOCK, facing);
    }

    public static Optional<IItemHandler> getInventoryForBlock(BlockEntity te) {
        return IOHelper.getInventoryForBlock(te, null);
    }

    public static Optional<IItemHandler> getSidedInventoryForEntity(Entity entity, Direction dir) {
        IItemHandler handler = (IItemHandler)entity.getCapability(PNCCapabilities.ENTITY_AUTOMATION, (Object)dir);
        if (handler == null && (handler = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY_AUTOMATION, (Object)dir)) == null) {
            handler = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY);
        }
        return Optional.ofNullable(handler);
    }

    public static Optional<IItemHandler> getInventoryForEntity(Entity entity) {
        return Optional.ofNullable((IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY));
    }

    public static Optional<IFluidHandler> getFluidHandlerForBlock(BlockEntity te, Direction facing) {
        return IOHelper.getCap(te, Capabilities.FluidHandler.BLOCK, facing);
    }

    public static Optional<IFluidHandler> getFluidHandlerForBlock(BlockEntity te) {
        return IOHelper.getFluidHandlerForBlock(te, null);
    }

    public static Optional<IFluidHandlerItem> getFluidHandlerForItem(ItemStack stack) {
        return Optional.ofNullable((IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM));
    }

    public static Optional<IFluidHandler> getFluidHandlerForEntity(Entity entity, Direction dir) {
        return Optional.ofNullable((IFluidHandler)entity.getCapability(Capabilities.FluidHandler.ENTITY, (Object)dir));
    }

    public static Optional<IEnergyStorage> getEnergyStorageForBlock(BlockEntity te, Direction side) {
        return IOHelper.getCap(te, Capabilities.EnergyStorage.BLOCK, side);
    }

    public static Optional<IEnergyStorage> getEnergyStorageForBlock(BlockEntity te) {
        return IOHelper.getCap(te, Capabilities.EnergyStorage.BLOCK, null);
    }

    public static Optional<IEnergyStorage> getEnergyStorageForItem(ItemStack item) {
        return Optional.ofNullable((IEnergyStorage)item.getCapability(Capabilities.EnergyStorage.ITEM));
    }

    public static ItemStack extract(IItemHandler handler, ItemStack requestedStack, ExtractCount countType, boolean simulate, boolean matchNBT) {
        if (requestedStack.isEmpty()) {
            return requestedStack;
        }
        if (handler != null) {
            int itemsFound = 0;
            IntArrayList slotsOfInterest = new IntArrayList();
            for (int slot = 0; slot < handler.getSlots() && itemsFound < requestedStack.getCount(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (stack.isEmpty() || !IOHelper.matchStacks(stack, requestedStack, matchNBT)) continue;
                if (countType == ExtractCount.FIRST_MATCHING) {
                    return handler.extractItem(slot, Math.min(requestedStack.getCount(), stack.getCount()), simulate);
                }
                itemsFound += stack.getCount();
                slotsOfInterest.add(slot);
            }
            if (countType == ExtractCount.UP_TO || itemsFound >= requestedStack.getCount()) {
                ItemStack exportedStack = ItemStack.EMPTY;
                int itemsNeeded = requestedStack.getCount();
                int totalExtracted = 0;
                IntListIterator intListIterator = slotsOfInterest.iterator();
                while (intListIterator.hasNext()) {
                    int slot = (Integer)intListIterator.next();
                    ItemStack stack = handler.getStackInSlot(slot);
                    if (!IOHelper.matchStacks(stack, requestedStack, matchNBT)) continue;
                    int itemsSubtracted = Math.min(itemsNeeded, stack.getCount());
                    if (itemsSubtracted > 0) {
                        exportedStack = stack;
                    }
                    itemsNeeded -= itemsSubtracted;
                    ItemStack extracted = handler.extractItem(slot, itemsSubtracted, simulate);
                    totalExtracted += extracted.getCount();
                }
                exportedStack = exportedStack.copy();
                exportedStack.setCount(totalExtracted);
                return exportedStack;
            }
        }
        return ItemStack.EMPTY;
    }

    private static boolean matchStacks(ItemStack stack1, ItemStack stack2, boolean matchNBT) {
        return matchNBT ? ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2) : ItemStack.isSameItem((ItemStack)stack1, (ItemStack)stack2);
    }

    @Nonnull
    public static ItemStack insert(BlockEntity tile, ItemStack itemStack, boolean simulate) {
        for (Direction side : Direction.values()) {
            ItemStack inserted = IOHelper.getInventoryForBlock(tile, side).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)itemStack.copy(), (boolean)simulate)).orElse(ItemStack.EMPTY);
            if (inserted.getCount() >= itemStack.getCount()) continue;
            return inserted;
        }
        return itemStack;
    }

    @Nonnull
    public static ItemStack insert(BlockEntity tile, ItemStack itemStack, Direction side, boolean simulate) {
        return IOHelper.getInventoryForBlock(tile, side).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)itemStack, (boolean)simulate)).orElse(itemStack);
    }

    public static boolean transferOneItem(IItemHandler input, IItemHandler output) {
        if (input == null || output == null) {
            return false;
        }
        for (int i = 0; i < input.getSlots(); ++i) {
            ItemStack extracted = input.extractItem(i, 1, true);
            if (extracted.isEmpty() || !ItemHandlerHelper.insertItemStacked((IItemHandler)output, (ItemStack)extracted, (boolean)false).isEmpty()) continue;
            input.extractItem(i, 1, false);
            return true;
        }
        return false;
    }

    public static void insertOrDrop(Level world, ItemStack stack, IItemHandler handler, Vec3 dropPos, boolean simulate) {
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
        if (!remainder.isEmpty() && !simulate) {
            ItemEntity item = new ItemEntity(world, dropPos.x(), dropPos.y(), dropPos.z(), remainder);
            world.addFreshEntity((Entity)item);
        }
    }

    public static int countItems(IItemHandler cap, Predicate<ItemStack> pred) {
        return IntStream.range(0, cap.getSlots()).filter(i -> pred.test(cap.getStackInSlot(i))).map(i -> cap.getStackInSlot(i).getCount()).sum();
    }

    public static <T> Optional<T> getCap(BlockEntity te, BlockCapability<T, Direction> cap, Direction face) {
        return te == null || te.getLevel() == null ? Optional.empty() : Optional.ofNullable(te.getLevel().getCapability(cap, te.getBlockPos(), te.getBlockState(), te, (Object)face));
    }

    public static <T> Optional<T> getCap(ItemStack stack, ItemCapability<T, Void> cap) {
        return Optional.ofNullable(stack.getCapability(cap));
    }

    public static <T> Optional<T> getCapV(Entity entity, EntityCapability<T, Void> cap) {
        return Optional.ofNullable(entity.getCapability(cap, null));
    }

    public static <T> Optional<T> getCap(Entity entity, EntityCapability<T, Direction> cap) {
        return Optional.ofNullable(entity.getCapability(cap, null));
    }

    public static enum ExtractCount {
        EXACT,
        FIRST_MATCHING,
        UP_TO;

    }
}

