/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.fakeplayer;

import com.mojang.authlib.GameProfile;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;

public class DroneFakePlayer
extends FakePlayer {
    private final IDroneBase drone;
    private boolean sneaking;

    public DroneFakePlayer(ServerLevel world, GameProfile name, IDroneBase drone) {
        super(world, name);
        this.drone = drone;
    }

    public void giveExperiencePoints(int amount) {
        Vec3 pos = this.drone.getDronePos();
        ExperienceOrb orb = new ExperienceOrb(this.drone.getDroneLevel(), pos.x, pos.y, pos.z, amount);
        this.drone.getDroneLevel().addFreshEntity((Entity)orb);
    }

    public void playNotifySound(SoundEvent soundEvent, SoundSource category, float volume, float pitch) {
        this.drone.playSound(soundEvent, category, volume, pitch);
    }

    public boolean isShiftKeyDown() {
        return this.sneaking;
    }

    public void setShiftKeyDown(boolean sneaking) {
        this.sneaking = sneaking;
    }

    public void tick() {
        ++this.attackStrengthTicker;
        this.getCooldowns().tick();
    }

    public boolean isSilent() {
        return true;
    }

    public Vec3 position() {
        return this.drone.getFakePlayerPos();
    }

    public BlockPos blockPosition() {
        return BlockPos.containing((Position)this.position());
    }
}

