/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.playerfilter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;

public record BiomeMatcher(List<TagKey<Biome>> tags) implements IPlayerMatcher
{
    private static final MapCodec<BiomeMatcher> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)TagKey.codec((ResourceKey)Registries.BIOME).listOf().fieldOf("biomes").forGetter(BiomeMatcher::tags)).apply((Applicative)builder, BiomeMatcher::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, BiomeMatcher> STREAM_CODEC = StreamCodec.of((buf, matcher) -> buf.writeCollection(matcher.tags, (b, key) -> b.writeResourceLocation(key.location())), buf -> new BiomeMatcher(buf.readList(b -> TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)b.readResourceLocation()))));
    public static final IPlayerMatcher.MatcherType<BiomeMatcher> TYPE = new IPlayerMatcher.MatcherType<BiomeMatcher>(CODEC, STREAM_CODEC);

    public IPlayerMatcher.MatcherType<?> type() {
        return TYPE;
    }

    @Override
    public void addDescription(Player player, List<Component> tooltip) {
        if (!this.tags.isEmpty()) {
            List<Component> items = this.tags.stream().map(tag -> Component.literal((String)tag.location().toString())).collect(Collectors.toList());
            this.standardTooltip(player, tooltip, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.biomes", new Object[0]), items);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(Player playerEntity) {
        if (this.tags.isEmpty()) return true;
        if (!playerEntity.level().getBiome(playerEntity.blockPosition()).tags().anyMatch(this.tags::contains)) return false;
        return true;
    }
}

