/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.compatibility;

import com.heaser.pipeconnector.compatibility.ae2.AE2Compatiblity;
import com.heaser.pipeconnector.compatibility.interfaces.IBlockEqualsChecker;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;

public class CompatibilityBlockEqualsChecker {
    private static CompatibilityBlockEqualsChecker INSTANCE;
    private static final HashMap<Class<? extends Block>, IBlockEqualsChecker> classToCheckerMap;

    private CompatibilityBlockEqualsChecker() {
        if (this.isModLoaded("ae2")) {
            classToCheckerMap.put(AE2Compatiblity.getBlockToRegister(), new AE2Compatiblity());
        }
    }

    private boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static CompatibilityBlockEqualsChecker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CompatibilityBlockEqualsChecker();
        }
        return INSTANCE;
    }

    public static boolean defaultIsBlockStateSpecificBlock(BlockPos pos, Block specificBlock, ItemStack placedItemStack, Level level) {
        return level.getBlockState(pos).getBlock().equals(specificBlock);
    }

    public static boolean isBlockStateSpecificBlock(BlockPos pos, Block specificBlock, ItemStack placedItemStack, Level level) {
        IBlockEqualsChecker checker = null;
        for (Map.Entry<Class<? extends Block>, IBlockEqualsChecker> set : classToCheckerMap.entrySet()) {
            if (!set.getKey().isAssignableFrom(specificBlock.getClass())) continue;
            checker = set.getValue();
            break;
        }
        if (checker != null) {
            return checker.isBlockStateSpecificBlock(pos, specificBlock, placedItemStack, level);
        }
        return CompatibilityBlockEqualsChecker.defaultIsBlockStateSpecificBlock(pos, specificBlock, placedItemStack, level);
    }

    static {
        classToCheckerMap = new HashMap();
    }
}

